/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v1.outputs.CrossVersionObjectReference;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HorizontalPodAutoscalerSpec {
    private Integer maxReplicas;
    @Nullable
    private Integer minReplicas;
    private CrossVersionObjectReference scaleTargetRef;
    @Nullable
    private Integer targetCPUUtilizationPercentage;

    private HorizontalPodAutoscalerSpec() {
    }

    public Integer maxReplicas() {
        return this.maxReplicas;
    }

    public Optional<Integer> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }

    public CrossVersionObjectReference scaleTargetRef() {
        return this.scaleTargetRef;
    }

    public Optional<Integer> targetCPUUtilizationPercentage() {
        return Optional.ofNullable(this.targetCPUUtilizationPercentage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Integer maxReplicas;
        @Nullable
        private Integer minReplicas;
        private CrossVersionObjectReference scaleTargetRef;
        @Nullable
        private Integer targetCPUUtilizationPercentage;

        public Builder() {
        }

        public Builder(HorizontalPodAutoscalerSpec defaults) {
            Objects.requireNonNull(defaults);
            this.maxReplicas = defaults.maxReplicas;
            this.minReplicas = defaults.minReplicas;
            this.scaleTargetRef = defaults.scaleTargetRef;
            this.targetCPUUtilizationPercentage = defaults.targetCPUUtilizationPercentage;
        }

        @CustomType.Setter
        public Builder maxReplicas(Integer maxReplicas) {
            if (maxReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpec", "maxReplicas");
            }
            this.maxReplicas = maxReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder minReplicas(@Nullable Integer minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder scaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
            if (scaleTargetRef == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpec", "scaleTargetRef");
            }
            this.scaleTargetRef = scaleTargetRef;
            return this;
        }

        @CustomType.Setter
        public Builder targetCPUUtilizationPercentage(@Nullable Integer targetCPUUtilizationPercentage) {
            this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
            return this;
        }

        public HorizontalPodAutoscalerSpec build() {
            HorizontalPodAutoscalerSpec _resultValue = new HorizontalPodAutoscalerSpec();
            _resultValue.maxReplicas = this.maxReplicas;
            _resultValue.minReplicas = this.minReplicas;
            _resultValue.scaleTargetRef = this.scaleTargetRef;
            _resultValue.targetCPUUtilizationPercentage = this.targetCPUUtilizationPercentage;
            return _resultValue;
        }
    }
}

