/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.autoscaling.v1.outputs.CrossVersionObjectReferencePatch;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HorizontalPodAutoscalerSpecPatch {
    @Nullable
    private Integer maxReplicas;
    @Nullable
    private Integer minReplicas;
    @Nullable
    private CrossVersionObjectReferencePatch scaleTargetRef;
    @Nullable
    private Integer targetCPUUtilizationPercentage;

    private HorizontalPodAutoscalerSpecPatch() {
    }

    public Optional<Integer> maxReplicas() {
        return Optional.ofNullable(this.maxReplicas);
    }

    public Optional<Integer> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }

    public Optional<CrossVersionObjectReferencePatch> scaleTargetRef() {
        return Optional.ofNullable(this.scaleTargetRef);
    }

    public Optional<Integer> targetCPUUtilizationPercentage() {
        return Optional.ofNullable(this.targetCPUUtilizationPercentage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerSpecPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer maxReplicas;
        @Nullable
        private Integer minReplicas;
        @Nullable
        private CrossVersionObjectReferencePatch scaleTargetRef;
        @Nullable
        private Integer targetCPUUtilizationPercentage;

        public Builder() {
        }

        public Builder(HorizontalPodAutoscalerSpecPatch defaults) {
            Objects.requireNonNull(defaults);
            this.maxReplicas = defaults.maxReplicas;
            this.minReplicas = defaults.minReplicas;
            this.scaleTargetRef = defaults.scaleTargetRef;
            this.targetCPUUtilizationPercentage = defaults.targetCPUUtilizationPercentage;
        }

        @CustomType.Setter
        public Builder maxReplicas(@Nullable Integer maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder minReplicas(@Nullable Integer minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder scaleTargetRef(@Nullable CrossVersionObjectReferencePatch scaleTargetRef) {
            this.scaleTargetRef = scaleTargetRef;
            return this;
        }

        @CustomType.Setter
        public Builder targetCPUUtilizationPercentage(@Nullable Integer targetCPUUtilizationPercentage) {
            this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
            return this;
        }

        public HorizontalPodAutoscalerSpecPatch build() {
            HorizontalPodAutoscalerSpecPatch _resultValue = new HorizontalPodAutoscalerSpecPatch();
            _resultValue.maxReplicas = this.maxReplicas;
            _resultValue.minReplicas = this.minReplicas;
            _resultValue.scaleTargetRef = this.scaleTargetRef;
            _resultValue.targetCPUUtilizationPercentage = this.targetCPUUtilizationPercentage;
            return _resultValue;
        }
    }
}

