/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HorizontalPodAutoscalerStatus {
    @Nullable
    private Integer currentCPUUtilizationPercentage;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    @Nullable
    private String lastScaleTime;
    @Nullable
    private Integer observedGeneration;

    private HorizontalPodAutoscalerStatus() {
    }

    public Optional<Integer> currentCPUUtilizationPercentage() {
        return Optional.ofNullable(this.currentCPUUtilizationPercentage);
    }

    public Integer currentReplicas() {
        return this.currentReplicas;
    }

    public Integer desiredReplicas() {
        return this.desiredReplicas;
    }

    public Optional<String> lastScaleTime() {
        return Optional.ofNullable(this.lastScaleTime);
    }

    public Optional<Integer> observedGeneration() {
        return Optional.ofNullable(this.observedGeneration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer currentCPUUtilizationPercentage;
        private Integer currentReplicas;
        private Integer desiredReplicas;
        @Nullable
        private String lastScaleTime;
        @Nullable
        private Integer observedGeneration;

        public Builder() {
        }

        public Builder(HorizontalPodAutoscalerStatus defaults) {
            Objects.requireNonNull(defaults);
            this.currentCPUUtilizationPercentage = defaults.currentCPUUtilizationPercentage;
            this.currentReplicas = defaults.currentReplicas;
            this.desiredReplicas = defaults.desiredReplicas;
            this.lastScaleTime = defaults.lastScaleTime;
            this.observedGeneration = defaults.observedGeneration;
        }

        @CustomType.Setter
        public Builder currentCPUUtilizationPercentage(@Nullable Integer currentCPUUtilizationPercentage) {
            this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
            return this;
        }

        @CustomType.Setter
        public Builder currentReplicas(Integer currentReplicas) {
            if (currentReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatus", "currentReplicas");
            }
            this.currentReplicas = currentReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder desiredReplicas(Integer desiredReplicas) {
            if (desiredReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatus", "desiredReplicas");
            }
            this.desiredReplicas = desiredReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder lastScaleTime(@Nullable String lastScaleTime) {
            this.lastScaleTime = lastScaleTime;
            return this;
        }

        @CustomType.Setter
        public Builder observedGeneration(@Nullable Integer observedGeneration) {
            this.observedGeneration = observedGeneration;
            return this;
        }

        public HorizontalPodAutoscalerStatus build() {
            HorizontalPodAutoscalerStatus _resultValue = new HorizontalPodAutoscalerStatus();
            _resultValue.currentCPUUtilizationPercentage = this.currentCPUUtilizationPercentage;
            _resultValue.currentReplicas = this.currentReplicas;
            _resultValue.desiredReplicas = this.desiredReplicas;
            _resultValue.lastScaleTime = this.lastScaleTime;
            _resultValue.observedGeneration = this.observedGeneration;
            return _resultValue;
        }
    }
}

