/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2.inputs.HorizontalPodAutoscalerConditionArgs;
import com.pulumi.kubernetes.autoscaling.v2.inputs.MetricStatusArgs;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HorizontalPodAutoscalerStatusArgs
extends ResourceArgs {
    public static final HorizontalPodAutoscalerStatusArgs Empty = new HorizontalPodAutoscalerStatusArgs();
    @Import(name="conditions")
    @Nullable
    private Output<List<HorizontalPodAutoscalerConditionArgs>> conditions;
    @Import(name="currentMetrics")
    @Nullable
    private Output<List<MetricStatusArgs>> currentMetrics;
    @Import(name="currentReplicas")
    @Nullable
    private Output<Integer> currentReplicas;
    @Import(name="desiredReplicas", required=true)
    private Output<Integer> desiredReplicas;
    @Import(name="lastScaleTime")
    @Nullable
    private Output<String> lastScaleTime;
    @Import(name="observedGeneration")
    @Nullable
    private Output<Integer> observedGeneration;

    public Optional<Output<List<HorizontalPodAutoscalerConditionArgs>>> conditions() {
        return Optional.ofNullable(this.conditions);
    }

    public Optional<Output<List<MetricStatusArgs>>> currentMetrics() {
        return Optional.ofNullable(this.currentMetrics);
    }

    public Optional<Output<Integer>> currentReplicas() {
        return Optional.ofNullable(this.currentReplicas);
    }

    public Output<Integer> desiredReplicas() {
        return this.desiredReplicas;
    }

    public Optional<Output<String>> lastScaleTime() {
        return Optional.ofNullable(this.lastScaleTime);
    }

    public Optional<Output<Integer>> observedGeneration() {
        return Optional.ofNullable(this.observedGeneration);
    }

    private HorizontalPodAutoscalerStatusArgs() {
    }

    private HorizontalPodAutoscalerStatusArgs(HorizontalPodAutoscalerStatusArgs $) {
        this.conditions = $.conditions;
        this.currentMetrics = $.currentMetrics;
        this.currentReplicas = $.currentReplicas;
        this.desiredReplicas = $.desiredReplicas;
        this.lastScaleTime = $.lastScaleTime;
        this.observedGeneration = $.observedGeneration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerStatusArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HorizontalPodAutoscalerStatusArgs $;

        public Builder() {
            this.$ = new HorizontalPodAutoscalerStatusArgs();
        }

        public Builder(HorizontalPodAutoscalerStatusArgs defaults) {
            this.$ = new HorizontalPodAutoscalerStatusArgs(Objects.requireNonNull(defaults));
        }

        public Builder conditions(@Nullable Output<List<HorizontalPodAutoscalerConditionArgs>> conditions) {
            this.$.conditions = conditions;
            return this;
        }

        public Builder conditions(List<HorizontalPodAutoscalerConditionArgs> conditions) {
            return this.conditions((Output<List<HorizontalPodAutoscalerConditionArgs>>)Output.of(conditions));
        }

        public Builder conditions(HorizontalPodAutoscalerConditionArgs ... conditions) {
            return this.conditions(List.of(conditions));
        }

        public Builder currentMetrics(@Nullable Output<List<MetricStatusArgs>> currentMetrics) {
            this.$.currentMetrics = currentMetrics;
            return this;
        }

        public Builder currentMetrics(List<MetricStatusArgs> currentMetrics) {
            return this.currentMetrics((Output<List<MetricStatusArgs>>)Output.of(currentMetrics));
        }

        public Builder currentMetrics(MetricStatusArgs ... currentMetrics) {
            return this.currentMetrics(List.of(currentMetrics));
        }

        public Builder currentReplicas(@Nullable Output<Integer> currentReplicas) {
            this.$.currentReplicas = currentReplicas;
            return this;
        }

        public Builder currentReplicas(Integer currentReplicas) {
            return this.currentReplicas((Output<Integer>)Output.of((Object)currentReplicas));
        }

        public Builder desiredReplicas(Output<Integer> desiredReplicas) {
            this.$.desiredReplicas = desiredReplicas;
            return this;
        }

        public Builder desiredReplicas(Integer desiredReplicas) {
            return this.desiredReplicas((Output<Integer>)Output.of((Object)desiredReplicas));
        }

        public Builder lastScaleTime(@Nullable Output<String> lastScaleTime) {
            this.$.lastScaleTime = lastScaleTime;
            return this;
        }

        public Builder lastScaleTime(String lastScaleTime) {
            return this.lastScaleTime((Output<String>)Output.of((Object)lastScaleTime));
        }

        public Builder observedGeneration(@Nullable Output<Integer> observedGeneration) {
            this.$.observedGeneration = observedGeneration;
            return this;
        }

        public Builder observedGeneration(Integer observedGeneration) {
            return this.observedGeneration((Output<Integer>)Output.of((Object)observedGeneration));
        }

        public HorizontalPodAutoscalerStatusArgs build() {
            if (this.$.desiredReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatusArgs", "desiredReplicas");
            }
            return this.$;
        }
    }
}

