/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2.outputs.CrossVersionObjectReference;
import com.pulumi.kubernetes.autoscaling.v2.outputs.HorizontalPodAutoscalerBehavior;
import com.pulumi.kubernetes.autoscaling.v2.outputs.MetricSpec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HorizontalPodAutoscalerSpec {
    @Nullable
    private HorizontalPodAutoscalerBehavior behavior;
    private Integer maxReplicas;
    @Nullable
    private List<MetricSpec> metrics;
    @Nullable
    private Integer minReplicas;
    private CrossVersionObjectReference scaleTargetRef;

    private HorizontalPodAutoscalerSpec() {
    }

    public Optional<HorizontalPodAutoscalerBehavior> behavior() {
        return Optional.ofNullable(this.behavior);
    }

    public Integer maxReplicas() {
        return this.maxReplicas;
    }

    public List<MetricSpec> metrics() {
        return this.metrics == null ? List.of() : this.metrics;
    }

    public Optional<Integer> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }

    public CrossVersionObjectReference scaleTargetRef() {
        return this.scaleTargetRef;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private HorizontalPodAutoscalerBehavior behavior;
        private Integer maxReplicas;
        @Nullable
        private List<MetricSpec> metrics;
        @Nullable
        private Integer minReplicas;
        private CrossVersionObjectReference scaleTargetRef;

        public Builder() {
        }

        public Builder(HorizontalPodAutoscalerSpec defaults) {
            Objects.requireNonNull(defaults);
            this.behavior = defaults.behavior;
            this.maxReplicas = defaults.maxReplicas;
            this.metrics = defaults.metrics;
            this.minReplicas = defaults.minReplicas;
            this.scaleTargetRef = defaults.scaleTargetRef;
        }

        @CustomType.Setter
        public Builder behavior(@Nullable HorizontalPodAutoscalerBehavior behavior) {
            this.behavior = behavior;
            return this;
        }

        @CustomType.Setter
        public Builder maxReplicas(Integer maxReplicas) {
            if (maxReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpec", "maxReplicas");
            }
            this.maxReplicas = maxReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder metrics(@Nullable List<MetricSpec> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder metrics(MetricSpec ... metrics) {
            return this.metrics(List.of(metrics));
        }

        @CustomType.Setter
        public Builder minReplicas(@Nullable Integer minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder scaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
            if (scaleTargetRef == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpec", "scaleTargetRef");
            }
            this.scaleTargetRef = scaleTargetRef;
            return this;
        }

        public HorizontalPodAutoscalerSpec build() {
            HorizontalPodAutoscalerSpec _resultValue = new HorizontalPodAutoscalerSpec();
            _resultValue.behavior = this.behavior;
            _resultValue.maxReplicas = this.maxReplicas;
            _resultValue.metrics = this.metrics;
            _resultValue.minReplicas = this.minReplicas;
            _resultValue.scaleTargetRef = this.scaleTargetRef;
            return _resultValue;
        }
    }
}

