/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.autoscaling.v2.outputs.CrossVersionObjectReferencePatch;
import com.pulumi.kubernetes.autoscaling.v2.outputs.HorizontalPodAutoscalerBehaviorPatch;
import com.pulumi.kubernetes.autoscaling.v2.outputs.MetricSpecPatch;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HorizontalPodAutoscalerSpecPatch {
    @Nullable
    private HorizontalPodAutoscalerBehaviorPatch behavior;
    @Nullable
    private Integer maxReplicas;
    @Nullable
    private List<MetricSpecPatch> metrics;
    @Nullable
    private Integer minReplicas;
    @Nullable
    private CrossVersionObjectReferencePatch scaleTargetRef;

    private HorizontalPodAutoscalerSpecPatch() {
    }

    public Optional<HorizontalPodAutoscalerBehaviorPatch> behavior() {
        return Optional.ofNullable(this.behavior);
    }

    public Optional<Integer> maxReplicas() {
        return Optional.ofNullable(this.maxReplicas);
    }

    public List<MetricSpecPatch> metrics() {
        return this.metrics == null ? List.of() : this.metrics;
    }

    public Optional<Integer> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }

    public Optional<CrossVersionObjectReferencePatch> scaleTargetRef() {
        return Optional.ofNullable(this.scaleTargetRef);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerSpecPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private HorizontalPodAutoscalerBehaviorPatch behavior;
        @Nullable
        private Integer maxReplicas;
        @Nullable
        private List<MetricSpecPatch> metrics;
        @Nullable
        private Integer minReplicas;
        @Nullable
        private CrossVersionObjectReferencePatch scaleTargetRef;

        public Builder() {
        }

        public Builder(HorizontalPodAutoscalerSpecPatch defaults) {
            Objects.requireNonNull(defaults);
            this.behavior = defaults.behavior;
            this.maxReplicas = defaults.maxReplicas;
            this.metrics = defaults.metrics;
            this.minReplicas = defaults.minReplicas;
            this.scaleTargetRef = defaults.scaleTargetRef;
        }

        @CustomType.Setter
        public Builder behavior(@Nullable HorizontalPodAutoscalerBehaviorPatch behavior) {
            this.behavior = behavior;
            return this;
        }

        @CustomType.Setter
        public Builder maxReplicas(@Nullable Integer maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder metrics(@Nullable List<MetricSpecPatch> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder metrics(MetricSpecPatch ... metrics) {
            return this.metrics(List.of(metrics));
        }

        @CustomType.Setter
        public Builder minReplicas(@Nullable Integer minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder scaleTargetRef(@Nullable CrossVersionObjectReferencePatch scaleTargetRef) {
            this.scaleTargetRef = scaleTargetRef;
            return this;
        }

        public HorizontalPodAutoscalerSpecPatch build() {
            HorizontalPodAutoscalerSpecPatch _resultValue = new HorizontalPodAutoscalerSpecPatch();
            _resultValue.behavior = this.behavior;
            _resultValue.maxReplicas = this.maxReplicas;
            _resultValue.metrics = this.metrics;
            _resultValue.minReplicas = this.minReplicas;
            _resultValue.scaleTargetRef = this.scaleTargetRef;
            return _resultValue;
        }
    }
}

