/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2.outputs.ContainerResourceMetricSource;
import com.pulumi.kubernetes.autoscaling.v2.outputs.ExternalMetricSource;
import com.pulumi.kubernetes.autoscaling.v2.outputs.ObjectMetricSource;
import com.pulumi.kubernetes.autoscaling.v2.outputs.PodsMetricSource;
import com.pulumi.kubernetes.autoscaling.v2.outputs.ResourceMetricSource;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class MetricSpec {
    @Nullable
    private ContainerResourceMetricSource containerResource;
    @Nullable
    private ExternalMetricSource external;
    @Nullable
    private ObjectMetricSource object;
    @Nullable
    private PodsMetricSource pods;
    @Nullable
    private ResourceMetricSource resource;
    private String type;

    private MetricSpec() {
    }

    public Optional<ContainerResourceMetricSource> containerResource() {
        return Optional.ofNullable(this.containerResource);
    }

    public Optional<ExternalMetricSource> external() {
        return Optional.ofNullable(this.external);
    }

    public Optional<ObjectMetricSource> object() {
        return Optional.ofNullable(this.object);
    }

    public Optional<PodsMetricSource> pods() {
        return Optional.ofNullable(this.pods);
    }

    public Optional<ResourceMetricSource> resource() {
        return Optional.ofNullable(this.resource);
    }

    public String type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetricSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private ContainerResourceMetricSource containerResource;
        @Nullable
        private ExternalMetricSource external;
        @Nullable
        private ObjectMetricSource object;
        @Nullable
        private PodsMetricSource pods;
        @Nullable
        private ResourceMetricSource resource;
        private String type;

        public Builder() {
        }

        public Builder(MetricSpec defaults) {
            Objects.requireNonNull(defaults);
            this.containerResource = defaults.containerResource;
            this.external = defaults.external;
            this.object = defaults.object;
            this.pods = defaults.pods;
            this.resource = defaults.resource;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder containerResource(@Nullable ContainerResourceMetricSource containerResource) {
            this.containerResource = containerResource;
            return this;
        }

        @CustomType.Setter
        public Builder external(@Nullable ExternalMetricSource external) {
            this.external = external;
            return this;
        }

        @CustomType.Setter
        public Builder object(@Nullable ObjectMetricSource object) {
            this.object = object;
            return this;
        }

        @CustomType.Setter
        public Builder pods(@Nullable PodsMetricSource pods) {
            this.pods = pods;
            return this;
        }

        @CustomType.Setter
        public Builder resource(@Nullable ResourceMetricSource resource) {
            this.resource = resource;
            return this;
        }

        @CustomType.Setter
        public Builder type(String type) {
            if (type == null) {
                throw new MissingRequiredPropertyException("MetricSpec", "type");
            }
            this.type = type;
            return this;
        }

        public MetricSpec build() {
            MetricSpec _resultValue = new MetricSpec();
            _resultValue.containerResource = this.containerResource;
            _resultValue.external = this.external;
            _resultValue.object = this.object;
            _resultValue.pods = this.pods;
            _resultValue.resource = this.resource;
            _resultValue.type = this.type;
            return _resultValue;
        }
    }
}

