/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class MetricTarget {
    @Nullable
    private Integer averageUtilization;
    @Nullable
    private String averageValue;
    private String type;
    @Nullable
    private String value;

    private MetricTarget() {
    }

    public Optional<Integer> averageUtilization() {
        return Optional.ofNullable(this.averageUtilization);
    }

    public Optional<String> averageValue() {
        return Optional.ofNullable(this.averageValue);
    }

    public String type() {
        return this.type;
    }

    public Optional<String> value() {
        return Optional.ofNullable(this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetricTarget defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer averageUtilization;
        @Nullable
        private String averageValue;
        private String type;
        @Nullable
        private String value;

        public Builder() {
        }

        public Builder(MetricTarget defaults) {
            Objects.requireNonNull(defaults);
            this.averageUtilization = defaults.averageUtilization;
            this.averageValue = defaults.averageValue;
            this.type = defaults.type;
            this.value = defaults.value;
        }

        @CustomType.Setter
        public Builder averageUtilization(@Nullable Integer averageUtilization) {
            this.averageUtilization = averageUtilization;
            return this;
        }

        @CustomType.Setter
        public Builder averageValue(@Nullable String averageValue) {
            this.averageValue = averageValue;
            return this;
        }

        @CustomType.Setter
        public Builder type(String type) {
            if (type == null) {
                throw new MissingRequiredPropertyException("MetricTarget", "type");
            }
            this.type = type;
            return this;
        }

        @CustomType.Setter
        public Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        public MetricTarget build() {
            MetricTarget _resultValue = new MetricTarget();
            _resultValue.averageUtilization = this.averageUtilization;
            _resultValue.averageValue = this.averageValue;
            _resultValue.type = this.type;
            _resultValue.value = this.value;
            return _resultValue;
        }
    }
}

