/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CrossVersionObjectReference {
    @Nullable
    private String apiVersion;
    private String kind;
    private String name;

    private CrossVersionObjectReference() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public String kind() {
        return this.kind;
    }

    public String name() {
        return this.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CrossVersionObjectReference defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        private String kind;
        private String name;

        public Builder() {
        }

        public Builder(CrossVersionObjectReference defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.name = defaults.name;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(String kind) {
            if (kind == null) {
                throw new MissingRequiredPropertyException("CrossVersionObjectReference", "kind");
            }
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("CrossVersionObjectReference", "name");
            }
            this.name = name;
            return this;
        }

        public CrossVersionObjectReference build() {
            CrossVersionObjectReference _resultValue = new CrossVersionObjectReference();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.name = this.name;
            return _resultValue;
        }
    }
}

