/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2beta1.outputs.CrossVersionObjectReference;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ObjectMetricSource {
    @Nullable
    private String averageValue;
    private String metricName;
    @Nullable
    private LabelSelector selector;
    private CrossVersionObjectReference target;
    private String targetValue;

    private ObjectMetricSource() {
    }

    public Optional<String> averageValue() {
        return Optional.ofNullable(this.averageValue);
    }

    public String metricName() {
        return this.metricName;
    }

    public Optional<LabelSelector> selector() {
        return Optional.ofNullable(this.selector);
    }

    public CrossVersionObjectReference target() {
        return this.target;
    }

    public String targetValue() {
        return this.targetValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObjectMetricSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String averageValue;
        private String metricName;
        @Nullable
        private LabelSelector selector;
        private CrossVersionObjectReference target;
        private String targetValue;

        public Builder() {
        }

        public Builder(ObjectMetricSource defaults) {
            Objects.requireNonNull(defaults);
            this.averageValue = defaults.averageValue;
            this.metricName = defaults.metricName;
            this.selector = defaults.selector;
            this.target = defaults.target;
            this.targetValue = defaults.targetValue;
        }

        @CustomType.Setter
        public Builder averageValue(@Nullable String averageValue) {
            this.averageValue = averageValue;
            return this;
        }

        @CustomType.Setter
        public Builder metricName(String metricName) {
            if (metricName == null) {
                throw new MissingRequiredPropertyException("ObjectMetricSource", "metricName");
            }
            this.metricName = metricName;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable LabelSelector selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder target(CrossVersionObjectReference target) {
            if (target == null) {
                throw new MissingRequiredPropertyException("ObjectMetricSource", "target");
            }
            this.target = target;
            return this;
        }

        @CustomType.Setter
        public Builder targetValue(String targetValue) {
            if (targetValue == null) {
                throw new MissingRequiredPropertyException("ObjectMetricSource", "targetValue");
            }
            this.targetValue = targetValue;
            return this;
        }

        public ObjectMetricSource build() {
            ObjectMetricSource _resultValue = new ObjectMetricSource();
            _resultValue.averageValue = this.averageValue;
            _resultValue.metricName = this.metricName;
            _resultValue.selector = this.selector;
            _resultValue.target = this.target;
            _resultValue.targetValue = this.targetValue;
            return _resultValue;
        }
    }
}

