/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2beta1.outputs.CrossVersionObjectReference;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ObjectMetricStatus {
    @Nullable
    private String averageValue;
    private String currentValue;
    private String metricName;
    @Nullable
    private LabelSelector selector;
    private CrossVersionObjectReference target;

    private ObjectMetricStatus() {
    }

    public Optional<String> averageValue() {
        return Optional.ofNullable(this.averageValue);
    }

    public String currentValue() {
        return this.currentValue;
    }

    public String metricName() {
        return this.metricName;
    }

    public Optional<LabelSelector> selector() {
        return Optional.ofNullable(this.selector);
    }

    public CrossVersionObjectReference target() {
        return this.target;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObjectMetricStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String averageValue;
        private String currentValue;
        private String metricName;
        @Nullable
        private LabelSelector selector;
        private CrossVersionObjectReference target;

        public Builder() {
        }

        public Builder(ObjectMetricStatus defaults) {
            Objects.requireNonNull(defaults);
            this.averageValue = defaults.averageValue;
            this.currentValue = defaults.currentValue;
            this.metricName = defaults.metricName;
            this.selector = defaults.selector;
            this.target = defaults.target;
        }

        @CustomType.Setter
        public Builder averageValue(@Nullable String averageValue) {
            this.averageValue = averageValue;
            return this;
        }

        @CustomType.Setter
        public Builder currentValue(String currentValue) {
            if (currentValue == null) {
                throw new MissingRequiredPropertyException("ObjectMetricStatus", "currentValue");
            }
            this.currentValue = currentValue;
            return this;
        }

        @CustomType.Setter
        public Builder metricName(String metricName) {
            if (metricName == null) {
                throw new MissingRequiredPropertyException("ObjectMetricStatus", "metricName");
            }
            this.metricName = metricName;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable LabelSelector selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder target(CrossVersionObjectReference target) {
            if (target == null) {
                throw new MissingRequiredPropertyException("ObjectMetricStatus", "target");
            }
            this.target = target;
            return this;
        }

        public ObjectMetricStatus build() {
            ObjectMetricStatus _resultValue = new ObjectMetricStatus();
            _resultValue.averageValue = this.averageValue;
            _resultValue.currentValue = this.currentValue;
            _resultValue.metricName = this.metricName;
            _resultValue.selector = this.selector;
            _resultValue.target = this.target;
            return _resultValue;
        }
    }
}

