/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceMetricSource {
    private String name;
    @Nullable
    private Integer targetAverageUtilization;
    @Nullable
    private String targetAverageValue;

    private ResourceMetricSource() {
    }

    public String name() {
        return this.name;
    }

    public Optional<Integer> targetAverageUtilization() {
        return Optional.ofNullable(this.targetAverageUtilization);
    }

    public Optional<String> targetAverageValue() {
        return Optional.ofNullable(this.targetAverageValue);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceMetricSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String name;
        @Nullable
        private Integer targetAverageUtilization;
        @Nullable
        private String targetAverageValue;

        public Builder() {
        }

        public Builder(ResourceMetricSource defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.targetAverageUtilization = defaults.targetAverageUtilization;
            this.targetAverageValue = defaults.targetAverageValue;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("ResourceMetricSource", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder targetAverageUtilization(@Nullable Integer targetAverageUtilization) {
            this.targetAverageUtilization = targetAverageUtilization;
            return this;
        }

        @CustomType.Setter
        public Builder targetAverageValue(@Nullable String targetAverageValue) {
            this.targetAverageValue = targetAverageValue;
            return this;
        }

        public ResourceMetricSource build() {
            ResourceMetricSource _resultValue = new ResourceMetricSource();
            _resultValue.name = this.name;
            _resultValue.targetAverageUtilization = this.targetAverageUtilization;
            _resultValue.targetAverageValue = this.targetAverageValue;
            return _resultValue;
        }
    }
}

