/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2beta2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2beta2.outputs.HorizontalPodAutoscalerCondition;
import com.pulumi.kubernetes.autoscaling.v2beta2.outputs.MetricStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HorizontalPodAutoscalerStatus {
    private List<HorizontalPodAutoscalerCondition> conditions;
    @Nullable
    private List<MetricStatus> currentMetrics;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    @Nullable
    private String lastScaleTime;
    @Nullable
    private Integer observedGeneration;

    private HorizontalPodAutoscalerStatus() {
    }

    public List<HorizontalPodAutoscalerCondition> conditions() {
        return this.conditions;
    }

    public List<MetricStatus> currentMetrics() {
        return this.currentMetrics == null ? List.of() : this.currentMetrics;
    }

    public Integer currentReplicas() {
        return this.currentReplicas;
    }

    public Integer desiredReplicas() {
        return this.desiredReplicas;
    }

    public Optional<String> lastScaleTime() {
        return Optional.ofNullable(this.lastScaleTime);
    }

    public Optional<Integer> observedGeneration() {
        return Optional.ofNullable(this.observedGeneration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<HorizontalPodAutoscalerCondition> conditions;
        @Nullable
        private List<MetricStatus> currentMetrics;
        private Integer currentReplicas;
        private Integer desiredReplicas;
        @Nullable
        private String lastScaleTime;
        @Nullable
        private Integer observedGeneration;

        public Builder() {
        }

        public Builder(HorizontalPodAutoscalerStatus defaults) {
            Objects.requireNonNull(defaults);
            this.conditions = defaults.conditions;
            this.currentMetrics = defaults.currentMetrics;
            this.currentReplicas = defaults.currentReplicas;
            this.desiredReplicas = defaults.desiredReplicas;
            this.lastScaleTime = defaults.lastScaleTime;
            this.observedGeneration = defaults.observedGeneration;
        }

        @CustomType.Setter
        public Builder conditions(List<HorizontalPodAutoscalerCondition> conditions) {
            if (conditions == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatus", "conditions");
            }
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(HorizontalPodAutoscalerCondition ... conditions) {
            return this.conditions(List.of(conditions));
        }

        @CustomType.Setter
        public Builder currentMetrics(@Nullable List<MetricStatus> currentMetrics) {
            this.currentMetrics = currentMetrics;
            return this;
        }

        public Builder currentMetrics(MetricStatus ... currentMetrics) {
            return this.currentMetrics(List.of(currentMetrics));
        }

        @CustomType.Setter
        public Builder currentReplicas(Integer currentReplicas) {
            if (currentReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatus", "currentReplicas");
            }
            this.currentReplicas = currentReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder desiredReplicas(Integer desiredReplicas) {
            if (desiredReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerStatus", "desiredReplicas");
            }
            this.desiredReplicas = desiredReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder lastScaleTime(@Nullable String lastScaleTime) {
            this.lastScaleTime = lastScaleTime;
            return this;
        }

        @CustomType.Setter
        public Builder observedGeneration(@Nullable Integer observedGeneration) {
            this.observedGeneration = observedGeneration;
            return this;
        }

        public HorizontalPodAutoscalerStatus build() {
            HorizontalPodAutoscalerStatus _resultValue = new HorizontalPodAutoscalerStatus();
            _resultValue.conditions = this.conditions;
            _resultValue.currentMetrics = this.currentMetrics;
            _resultValue.currentReplicas = this.currentReplicas;
            _resultValue.desiredReplicas = this.desiredReplicas;
            _resultValue.lastScaleTime = this.lastScaleTime;
            _resultValue.observedGeneration = this.observedGeneration;
            return _resultValue;
        }
    }
}

