/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v2beta2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v2beta2.outputs.ContainerResourceMetricStatus;
import com.pulumi.kubernetes.autoscaling.v2beta2.outputs.ExternalMetricStatus;
import com.pulumi.kubernetes.autoscaling.v2beta2.outputs.ObjectMetricStatus;
import com.pulumi.kubernetes.autoscaling.v2beta2.outputs.PodsMetricStatus;
import com.pulumi.kubernetes.autoscaling.v2beta2.outputs.ResourceMetricStatus;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class MetricStatus {
    @Nullable
    private ContainerResourceMetricStatus containerResource;
    @Nullable
    private ExternalMetricStatus external;
    @Nullable
    private ObjectMetricStatus object;
    @Nullable
    private PodsMetricStatus pods;
    @Nullable
    private ResourceMetricStatus resource;
    private String type;

    private MetricStatus() {
    }

    public Optional<ContainerResourceMetricStatus> containerResource() {
        return Optional.ofNullable(this.containerResource);
    }

    public Optional<ExternalMetricStatus> external() {
        return Optional.ofNullable(this.external);
    }

    public Optional<ObjectMetricStatus> object() {
        return Optional.ofNullable(this.object);
    }

    public Optional<PodsMetricStatus> pods() {
        return Optional.ofNullable(this.pods);
    }

    public Optional<ResourceMetricStatus> resource() {
        return Optional.ofNullable(this.resource);
    }

    public String type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetricStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private ContainerResourceMetricStatus containerResource;
        @Nullable
        private ExternalMetricStatus external;
        @Nullable
        private ObjectMetricStatus object;
        @Nullable
        private PodsMetricStatus pods;
        @Nullable
        private ResourceMetricStatus resource;
        private String type;

        public Builder() {
        }

        public Builder(MetricStatus defaults) {
            Objects.requireNonNull(defaults);
            this.containerResource = defaults.containerResource;
            this.external = defaults.external;
            this.object = defaults.object;
            this.pods = defaults.pods;
            this.resource = defaults.resource;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder containerResource(@Nullable ContainerResourceMetricStatus containerResource) {
            this.containerResource = containerResource;
            return this;
        }

        @CustomType.Setter
        public Builder external(@Nullable ExternalMetricStatus external) {
            this.external = external;
            return this;
        }

        @CustomType.Setter
        public Builder object(@Nullable ObjectMetricStatus object) {
            this.object = object;
            return this;
        }

        @CustomType.Setter
        public Builder pods(@Nullable PodsMetricStatus pods) {
            this.pods = pods;
            return this;
        }

        @CustomType.Setter
        public Builder resource(@Nullable ResourceMetricStatus resource) {
            this.resource = resource;
            return this;
        }

        @CustomType.Setter
        public Builder type(String type) {
            if (type == null) {
                throw new MissingRequiredPropertyException("MetricStatus", "type");
            }
            this.type = type;
            return this;
        }

        public MetricStatus build() {
            MetricStatus _resultValue = new MetricStatus();
            _resultValue.containerResource = this.containerResource;
            _resultValue.external = this.external;
            _resultValue.object = this.object;
            _resultValue.pods = this.pods;
            _resultValue.resource = this.resource;
            _resultValue.type = this.type;
            return _resultValue;
        }
    }
}

