/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.batch.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.batch.v1.outputs.JobCondition;
import com.pulumi.kubernetes.batch.v1.outputs.UncountedTerminatedPods;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class JobStatus {
    @Nullable
    private Integer active;
    @Nullable
    private String completedIndexes;
    @Nullable
    private String completionTime;
    @Nullable
    private List<JobCondition> conditions;
    @Nullable
    private Integer failed;
    @Nullable
    private String failedIndexes;
    @Nullable
    private Integer ready;
    @Nullable
    private String startTime;
    @Nullable
    private Integer succeeded;
    @Nullable
    private Integer terminating;
    @Nullable
    private UncountedTerminatedPods uncountedTerminatedPods;

    private JobStatus() {
    }

    public Optional<Integer> active() {
        return Optional.ofNullable(this.active);
    }

    public Optional<String> completedIndexes() {
        return Optional.ofNullable(this.completedIndexes);
    }

    public Optional<String> completionTime() {
        return Optional.ofNullable(this.completionTime);
    }

    public List<JobCondition> conditions() {
        return this.conditions == null ? List.of() : this.conditions;
    }

    public Optional<Integer> failed() {
        return Optional.ofNullable(this.failed);
    }

    public Optional<String> failedIndexes() {
        return Optional.ofNullable(this.failedIndexes);
    }

    public Optional<Integer> ready() {
        return Optional.ofNullable(this.ready);
    }

    public Optional<String> startTime() {
        return Optional.ofNullable(this.startTime);
    }

    public Optional<Integer> succeeded() {
        return Optional.ofNullable(this.succeeded);
    }

    public Optional<Integer> terminating() {
        return Optional.ofNullable(this.terminating);
    }

    public Optional<UncountedTerminatedPods> uncountedTerminatedPods() {
        return Optional.ofNullable(this.uncountedTerminatedPods);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JobStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer active;
        @Nullable
        private String completedIndexes;
        @Nullable
        private String completionTime;
        @Nullable
        private List<JobCondition> conditions;
        @Nullable
        private Integer failed;
        @Nullable
        private String failedIndexes;
        @Nullable
        private Integer ready;
        @Nullable
        private String startTime;
        @Nullable
        private Integer succeeded;
        @Nullable
        private Integer terminating;
        @Nullable
        private UncountedTerminatedPods uncountedTerminatedPods;

        public Builder() {
        }

        public Builder(JobStatus defaults) {
            Objects.requireNonNull(defaults);
            this.active = defaults.active;
            this.completedIndexes = defaults.completedIndexes;
            this.completionTime = defaults.completionTime;
            this.conditions = defaults.conditions;
            this.failed = defaults.failed;
            this.failedIndexes = defaults.failedIndexes;
            this.ready = defaults.ready;
            this.startTime = defaults.startTime;
            this.succeeded = defaults.succeeded;
            this.terminating = defaults.terminating;
            this.uncountedTerminatedPods = defaults.uncountedTerminatedPods;
        }

        @CustomType.Setter
        public Builder active(@Nullable Integer active) {
            this.active = active;
            return this;
        }

        @CustomType.Setter
        public Builder completedIndexes(@Nullable String completedIndexes) {
            this.completedIndexes = completedIndexes;
            return this;
        }

        @CustomType.Setter
        public Builder completionTime(@Nullable String completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        @CustomType.Setter
        public Builder conditions(@Nullable List<JobCondition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(JobCondition ... conditions) {
            return this.conditions(List.of(conditions));
        }

        @CustomType.Setter
        public Builder failed(@Nullable Integer failed) {
            this.failed = failed;
            return this;
        }

        @CustomType.Setter
        public Builder failedIndexes(@Nullable String failedIndexes) {
            this.failedIndexes = failedIndexes;
            return this;
        }

        @CustomType.Setter
        public Builder ready(@Nullable Integer ready) {
            this.ready = ready;
            return this;
        }

        @CustomType.Setter
        public Builder startTime(@Nullable String startTime) {
            this.startTime = startTime;
            return this;
        }

        @CustomType.Setter
        public Builder succeeded(@Nullable Integer succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        @CustomType.Setter
        public Builder terminating(@Nullable Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        @CustomType.Setter
        public Builder uncountedTerminatedPods(@Nullable UncountedTerminatedPods uncountedTerminatedPods) {
            this.uncountedTerminatedPods = uncountedTerminatedPods;
            return this;
        }

        public JobStatus build() {
            JobStatus _resultValue = new JobStatus();
            _resultValue.active = this.active;
            _resultValue.completedIndexes = this.completedIndexes;
            _resultValue.completionTime = this.completionTime;
            _resultValue.conditions = this.conditions;
            _resultValue.failed = this.failed;
            _resultValue.failedIndexes = this.failedIndexes;
            _resultValue.ready = this.ready;
            _resultValue.startTime = this.startTime;
            _resultValue.succeeded = this.succeeded;
            _resultValue.terminating = this.terminating;
            _resultValue.uncountedTerminatedPods = this.uncountedTerminatedPods;
            return _resultValue;
        }
    }
}

