/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.batch.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.batch.v1.outputs.PodFailurePolicyOnExitCodesRequirement;
import com.pulumi.kubernetes.batch.v1.outputs.PodFailurePolicyOnPodConditionsPattern;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodFailurePolicyRule {
    private String action;
    @Nullable
    private PodFailurePolicyOnExitCodesRequirement onExitCodes;
    @Nullable
    private List<PodFailurePolicyOnPodConditionsPattern> onPodConditions;

    private PodFailurePolicyRule() {
    }

    public String action() {
        return this.action;
    }

    public Optional<PodFailurePolicyOnExitCodesRequirement> onExitCodes() {
        return Optional.ofNullable(this.onExitCodes);
    }

    public List<PodFailurePolicyOnPodConditionsPattern> onPodConditions() {
        return this.onPodConditions == null ? List.of() : this.onPodConditions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodFailurePolicyRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String action;
        @Nullable
        private PodFailurePolicyOnExitCodesRequirement onExitCodes;
        @Nullable
        private List<PodFailurePolicyOnPodConditionsPattern> onPodConditions;

        public Builder() {
        }

        public Builder(PodFailurePolicyRule defaults) {
            Objects.requireNonNull(defaults);
            this.action = defaults.action;
            this.onExitCodes = defaults.onExitCodes;
            this.onPodConditions = defaults.onPodConditions;
        }

        @CustomType.Setter
        public Builder action(String action) {
            if (action == null) {
                throw new MissingRequiredPropertyException("PodFailurePolicyRule", "action");
            }
            this.action = action;
            return this;
        }

        @CustomType.Setter
        public Builder onExitCodes(@Nullable PodFailurePolicyOnExitCodesRequirement onExitCodes) {
            this.onExitCodes = onExitCodes;
            return this;
        }

        @CustomType.Setter
        public Builder onPodConditions(@Nullable List<PodFailurePolicyOnPodConditionsPattern> onPodConditions) {
            this.onPodConditions = onPodConditions;
            return this;
        }

        public Builder onPodConditions(PodFailurePolicyOnPodConditionsPattern ... onPodConditions) {
            return this.onPodConditions(List.of(onPodConditions));
        }

        public PodFailurePolicyRule build() {
            PodFailurePolicyRule _resultValue = new PodFailurePolicyRule();
            _resultValue.action = this.action;
            _resultValue.onExitCodes = this.onExitCodes;
            _resultValue.onPodConditions = this.onPodConditions;
            return _resultValue;
        }
    }
}

