/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.batch.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.batch.v1beta1.outputs.JobTemplateSpec;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CronJobSpec {
    @Nullable
    private String concurrencyPolicy;
    @Nullable
    private Integer failedJobsHistoryLimit;
    private JobTemplateSpec jobTemplate;
    private String schedule;
    @Nullable
    private Integer startingDeadlineSeconds;
    @Nullable
    private Integer successfulJobsHistoryLimit;
    @Nullable
    private Boolean suspend;

    private CronJobSpec() {
    }

    public Optional<String> concurrencyPolicy() {
        return Optional.ofNullable(this.concurrencyPolicy);
    }

    public Optional<Integer> failedJobsHistoryLimit() {
        return Optional.ofNullable(this.failedJobsHistoryLimit);
    }

    public JobTemplateSpec jobTemplate() {
        return this.jobTemplate;
    }

    public String schedule() {
        return this.schedule;
    }

    public Optional<Integer> startingDeadlineSeconds() {
        return Optional.ofNullable(this.startingDeadlineSeconds);
    }

    public Optional<Integer> successfulJobsHistoryLimit() {
        return Optional.ofNullable(this.successfulJobsHistoryLimit);
    }

    public Optional<Boolean> suspend() {
        return Optional.ofNullable(this.suspend);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CronJobSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String concurrencyPolicy;
        @Nullable
        private Integer failedJobsHistoryLimit;
        private JobTemplateSpec jobTemplate;
        private String schedule;
        @Nullable
        private Integer startingDeadlineSeconds;
        @Nullable
        private Integer successfulJobsHistoryLimit;
        @Nullable
        private Boolean suspend;

        public Builder() {
        }

        public Builder(CronJobSpec defaults) {
            Objects.requireNonNull(defaults);
            this.concurrencyPolicy = defaults.concurrencyPolicy;
            this.failedJobsHistoryLimit = defaults.failedJobsHistoryLimit;
            this.jobTemplate = defaults.jobTemplate;
            this.schedule = defaults.schedule;
            this.startingDeadlineSeconds = defaults.startingDeadlineSeconds;
            this.successfulJobsHistoryLimit = defaults.successfulJobsHistoryLimit;
            this.suspend = defaults.suspend;
        }

        @CustomType.Setter
        public Builder concurrencyPolicy(@Nullable String concurrencyPolicy) {
            this.concurrencyPolicy = concurrencyPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder failedJobsHistoryLimit(@Nullable Integer failedJobsHistoryLimit) {
            this.failedJobsHistoryLimit = failedJobsHistoryLimit;
            return this;
        }

        @CustomType.Setter
        public Builder jobTemplate(JobTemplateSpec jobTemplate) {
            if (jobTemplate == null) {
                throw new MissingRequiredPropertyException("CronJobSpec", "jobTemplate");
            }
            this.jobTemplate = jobTemplate;
            return this;
        }

        @CustomType.Setter
        public Builder schedule(String schedule) {
            if (schedule == null) {
                throw new MissingRequiredPropertyException("CronJobSpec", "schedule");
            }
            this.schedule = schedule;
            return this;
        }

        @CustomType.Setter
        public Builder startingDeadlineSeconds(@Nullable Integer startingDeadlineSeconds) {
            this.startingDeadlineSeconds = startingDeadlineSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder successfulJobsHistoryLimit(@Nullable Integer successfulJobsHistoryLimit) {
            this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
            return this;
        }

        @CustomType.Setter
        public Builder suspend(@Nullable Boolean suspend) {
            this.suspend = suspend;
            return this;
        }

        public CronJobSpec build() {
            CronJobSpec _resultValue = new CronJobSpec();
            _resultValue.concurrencyPolicy = this.concurrencyPolicy;
            _resultValue.failedJobsHistoryLimit = this.failedJobsHistoryLimit;
            _resultValue.jobTemplate = this.jobTemplate;
            _resultValue.schedule = this.schedule;
            _resultValue.startingDeadlineSeconds = this.startingDeadlineSeconds;
            _resultValue.successfulJobsHistoryLimit = this.successfulJobsHistoryLimit;
            _resultValue.suspend = this.suspend;
            return _resultValue;
        }
    }
}

