/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.certificates.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CertificateSigningRequestSpec {
    @Nullable
    private Integer expirationSeconds;
    @Nullable
    private Map<String, List<String>> extra;
    @Nullable
    private List<String> groups;
    private String request;
    private String signerName;
    @Nullable
    private String uid;
    @Nullable
    private List<String> usages;
    @Nullable
    private String username;

    private CertificateSigningRequestSpec() {
    }

    public Optional<Integer> expirationSeconds() {
        return Optional.ofNullable(this.expirationSeconds);
    }

    public Map<String, List<String>> extra() {
        return this.extra == null ? Map.of() : this.extra;
    }

    public List<String> groups() {
        return this.groups == null ? List.of() : this.groups;
    }

    public String request() {
        return this.request;
    }

    public String signerName() {
        return this.signerName;
    }

    public Optional<String> uid() {
        return Optional.ofNullable(this.uid);
    }

    public List<String> usages() {
        return this.usages == null ? List.of() : this.usages;
    }

    public Optional<String> username() {
        return Optional.ofNullable(this.username);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CertificateSigningRequestSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer expirationSeconds;
        @Nullable
        private Map<String, List<String>> extra;
        @Nullable
        private List<String> groups;
        private String request;
        private String signerName;
        @Nullable
        private String uid;
        @Nullable
        private List<String> usages;
        @Nullable
        private String username;

        public Builder() {
        }

        public Builder(CertificateSigningRequestSpec defaults) {
            Objects.requireNonNull(defaults);
            this.expirationSeconds = defaults.expirationSeconds;
            this.extra = defaults.extra;
            this.groups = defaults.groups;
            this.request = defaults.request;
            this.signerName = defaults.signerName;
            this.uid = defaults.uid;
            this.usages = defaults.usages;
            this.username = defaults.username;
        }

        @CustomType.Setter
        public Builder expirationSeconds(@Nullable Integer expirationSeconds) {
            this.expirationSeconds = expirationSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder extra(@Nullable Map<String, List<String>> extra) {
            this.extra = extra;
            return this;
        }

        @CustomType.Setter
        public Builder groups(@Nullable List<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder groups(String ... groups) {
            return this.groups(List.of(groups));
        }

        @CustomType.Setter
        public Builder request(String request) {
            if (request == null) {
                throw new MissingRequiredPropertyException("CertificateSigningRequestSpec", "request");
            }
            this.request = request;
            return this;
        }

        @CustomType.Setter
        public Builder signerName(String signerName) {
            if (signerName == null) {
                throw new MissingRequiredPropertyException("CertificateSigningRequestSpec", "signerName");
            }
            this.signerName = signerName;
            return this;
        }

        @CustomType.Setter
        public Builder uid(@Nullable String uid) {
            this.uid = uid;
            return this;
        }

        @CustomType.Setter
        public Builder usages(@Nullable List<String> usages) {
            this.usages = usages;
            return this;
        }

        public Builder usages(String ... usages) {
            return this.usages(List.of(usages));
        }

        @CustomType.Setter
        public Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public CertificateSigningRequestSpec build() {
            CertificateSigningRequestSpec _resultValue = new CertificateSigningRequestSpec();
            _resultValue.expirationSeconds = this.expirationSeconds;
            _resultValue.extra = this.extra;
            _resultValue.groups = this.groups;
            _resultValue.request = this.request;
            _resultValue.signerName = this.signerName;
            _resultValue.uid = this.uid;
            _resultValue.usages = this.usages;
            _resultValue.username = this.username;
            return _resultValue;
        }
    }
}

