/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.coordination.v1alpha1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LeaseCandidateSpec {
    @Nullable
    private String binaryVersion;
    @Nullable
    private String emulationVersion;
    private String leaseName;
    @Nullable
    private String pingTime;
    private List<String> preferredStrategies;
    @Nullable
    private String renewTime;

    private LeaseCandidateSpec() {
    }

    public Optional<String> binaryVersion() {
        return Optional.ofNullable(this.binaryVersion);
    }

    public Optional<String> emulationVersion() {
        return Optional.ofNullable(this.emulationVersion);
    }

    public String leaseName() {
        return this.leaseName;
    }

    public Optional<String> pingTime() {
        return Optional.ofNullable(this.pingTime);
    }

    public List<String> preferredStrategies() {
        return this.preferredStrategies;
    }

    public Optional<String> renewTime() {
        return Optional.ofNullable(this.renewTime);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LeaseCandidateSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String binaryVersion;
        @Nullable
        private String emulationVersion;
        private String leaseName;
        @Nullable
        private String pingTime;
        private List<String> preferredStrategies;
        @Nullable
        private String renewTime;

        public Builder() {
        }

        public Builder(LeaseCandidateSpec defaults) {
            Objects.requireNonNull(defaults);
            this.binaryVersion = defaults.binaryVersion;
            this.emulationVersion = defaults.emulationVersion;
            this.leaseName = defaults.leaseName;
            this.pingTime = defaults.pingTime;
            this.preferredStrategies = defaults.preferredStrategies;
            this.renewTime = defaults.renewTime;
        }

        @CustomType.Setter
        public Builder binaryVersion(@Nullable String binaryVersion) {
            this.binaryVersion = binaryVersion;
            return this;
        }

        @CustomType.Setter
        public Builder emulationVersion(@Nullable String emulationVersion) {
            this.emulationVersion = emulationVersion;
            return this;
        }

        @CustomType.Setter
        public Builder leaseName(String leaseName) {
            if (leaseName == null) {
                throw new MissingRequiredPropertyException("LeaseCandidateSpec", "leaseName");
            }
            this.leaseName = leaseName;
            return this;
        }

        @CustomType.Setter
        public Builder pingTime(@Nullable String pingTime) {
            this.pingTime = pingTime;
            return this;
        }

        @CustomType.Setter
        public Builder preferredStrategies(List<String> preferredStrategies) {
            if (preferredStrategies == null) {
                throw new MissingRequiredPropertyException("LeaseCandidateSpec", "preferredStrategies");
            }
            this.preferredStrategies = preferredStrategies;
            return this;
        }

        public Builder preferredStrategies(String ... preferredStrategies) {
            return this.preferredStrategies(List.of(preferredStrategies));
        }

        @CustomType.Setter
        public Builder renewTime(@Nullable String renewTime) {
            this.renewTime = renewTime;
            return this;
        }

        public LeaseCandidateSpec build() {
            LeaseCandidateSpec _resultValue = new LeaseCandidateSpec();
            _resultValue.binaryVersion = this.binaryVersion;
            _resultValue.emulationVersion = this.emulationVersion;
            _resultValue.leaseName = this.leaseName;
            _resultValue.pingTime = this.pingTime;
            _resultValue.preferredStrategies = this.preferredStrategies;
            _resultValue.renewTime = this.renewTime;
            return _resultValue;
        }
    }
}

