/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.core.v1.ServiceAccountArgs;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReference;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.resources.CustomResource;
import com.pulumi.resources.CustomResourceOptions;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import javax.annotation.Nullable;

@ResourceType(type="kubernetes:core/v1:ServiceAccount")
public class ServiceAccount
extends CustomResource {
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output<String> apiVersion;
    @Export(name="automountServiceAccountToken", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> automountServiceAccountToken;
    @Export(name="imagePullSecrets", refs={List.class, LocalObjectReference.class}, tree="[0,1]")
    private Output<List<LocalObjectReference>> imagePullSecrets;
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output<String> kind;
    @Export(name="metadata", refs={ObjectMeta.class}, tree="[0]")
    private Output<ObjectMeta> metadata;
    @Export(name="secrets", refs={List.class, ObjectReference.class}, tree="[0,1]")
    private Output<List<ObjectReference>> secrets;

    public Output<String> apiVersion() {
        return this.apiVersion;
    }

    public Output<Boolean> automountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public Output<List<LocalObjectReference>> imagePullSecrets() {
        return this.imagePullSecrets;
    }

    public Output<String> kind() {
        return this.kind;
    }

    public Output<ObjectMeta> metadata() {
        return this.metadata;
    }

    public Output<List<ObjectReference>> secrets() {
        return this.secrets;
    }

    public ServiceAccount(String name) {
        this(name, ServiceAccountArgs.Empty);
    }

    public ServiceAccount(String name, @Nullable ServiceAccountArgs args) {
        this(name, args, null);
    }

    public ServiceAccount(String name, @Nullable ServiceAccountArgs args, @Nullable CustomResourceOptions options) {
        super("kubernetes:core/v1:ServiceAccount", name, (ResourceArgs)ServiceAccount.makeArgs(args, options), ServiceAccount.makeResourceOptions(options, (Output<String>)Codegen.empty()));
    }

    private ServiceAccount(String name, Output<String> id, @Nullable CustomResourceOptions options) {
        super("kubernetes:core/v1:ServiceAccount", name, null, ServiceAccount.makeResourceOptions(options, id));
    }

    private static ServiceAccountArgs makeArgs(@Nullable ServiceAccountArgs args, @Nullable CustomResourceOptions options) {
        if (options != null && options.getUrn().isPresent()) {
            return null;
        }
        ServiceAccountArgs.Builder builder = args == null ? ServiceAccountArgs.builder() : ServiceAccountArgs.builder(args);
        return builder.apiVersion("v1").kind("ServiceAccount").build();
    }

    private static CustomResourceOptions makeResourceOptions(@Nullable CustomResourceOptions options, @Nullable Output<String> id) {
        CustomResourceOptions defaultOptions = ((CustomResourceOptions.Builder)CustomResourceOptions.builder().version(Utilities.getVersion())).build();
        return CustomResourceOptions.merge((CustomResourceOptions)defaultOptions, (CustomResourceOptions)options, id);
    }

    public static ServiceAccount get(String name, Output<String> id, @Nullable CustomResourceOptions options) {
        return new ServiceAccount(name, id, options);
    }
}

