/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.ContainerStateArgs;
import com.pulumi.kubernetes.core.v1.inputs.ContainerUserArgs;
import com.pulumi.kubernetes.core.v1.inputs.ResourceRequirementsArgs;
import com.pulumi.kubernetes.core.v1.inputs.ResourceStatusArgs;
import com.pulumi.kubernetes.core.v1.inputs.VolumeMountStatusArgs;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ContainerStatusArgs
extends ResourceArgs {
    public static final ContainerStatusArgs Empty = new ContainerStatusArgs();
    @Import(name="allocatedResources")
    @Nullable
    private Output<Map<String, String>> allocatedResources;
    @Import(name="allocatedResourcesStatus")
    @Nullable
    private Output<List<ResourceStatusArgs>> allocatedResourcesStatus;
    @Import(name="containerID")
    @Nullable
    private Output<String> containerID;
    @Import(name="image", required=true)
    private Output<String> image;
    @Import(name="imageID", required=true)
    private Output<String> imageID;
    @Import(name="lastState")
    @Nullable
    private Output<ContainerStateArgs> lastState;
    @Import(name="name", required=true)
    private Output<String> name;
    @Import(name="ready", required=true)
    private Output<Boolean> ready;
    @Import(name="resources")
    @Nullable
    private Output<ResourceRequirementsArgs> resources;
    @Import(name="restartCount", required=true)
    private Output<Integer> restartCount;
    @Import(name="started")
    @Nullable
    private Output<Boolean> started;
    @Import(name="state")
    @Nullable
    private Output<ContainerStateArgs> state;
    @Import(name="user")
    @Nullable
    private Output<ContainerUserArgs> user;
    @Import(name="volumeMounts")
    @Nullable
    private Output<List<VolumeMountStatusArgs>> volumeMounts;

    public Optional<Output<Map<String, String>>> allocatedResources() {
        return Optional.ofNullable(this.allocatedResources);
    }

    public Optional<Output<List<ResourceStatusArgs>>> allocatedResourcesStatus() {
        return Optional.ofNullable(this.allocatedResourcesStatus);
    }

    public Optional<Output<String>> containerID() {
        return Optional.ofNullable(this.containerID);
    }

    public Output<String> image() {
        return this.image;
    }

    public Output<String> imageID() {
        return this.imageID;
    }

    public Optional<Output<ContainerStateArgs>> lastState() {
        return Optional.ofNullable(this.lastState);
    }

    public Output<String> name() {
        return this.name;
    }

    public Output<Boolean> ready() {
        return this.ready;
    }

    public Optional<Output<ResourceRequirementsArgs>> resources() {
        return Optional.ofNullable(this.resources);
    }

    public Output<Integer> restartCount() {
        return this.restartCount;
    }

    public Optional<Output<Boolean>> started() {
        return Optional.ofNullable(this.started);
    }

    public Optional<Output<ContainerStateArgs>> state() {
        return Optional.ofNullable(this.state);
    }

    public Optional<Output<ContainerUserArgs>> user() {
        return Optional.ofNullable(this.user);
    }

    public Optional<Output<List<VolumeMountStatusArgs>>> volumeMounts() {
        return Optional.ofNullable(this.volumeMounts);
    }

    private ContainerStatusArgs() {
    }

    private ContainerStatusArgs(ContainerStatusArgs $) {
        this.allocatedResources = $.allocatedResources;
        this.allocatedResourcesStatus = $.allocatedResourcesStatus;
        this.containerID = $.containerID;
        this.image = $.image;
        this.imageID = $.imageID;
        this.lastState = $.lastState;
        this.name = $.name;
        this.ready = $.ready;
        this.resources = $.resources;
        this.restartCount = $.restartCount;
        this.started = $.started;
        this.state = $.state;
        this.user = $.user;
        this.volumeMounts = $.volumeMounts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerStatusArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerStatusArgs $;

        public Builder() {
            this.$ = new ContainerStatusArgs();
        }

        public Builder(ContainerStatusArgs defaults) {
            this.$ = new ContainerStatusArgs(Objects.requireNonNull(defaults));
        }

        public Builder allocatedResources(@Nullable Output<Map<String, String>> allocatedResources) {
            this.$.allocatedResources = allocatedResources;
            return this;
        }

        public Builder allocatedResources(Map<String, String> allocatedResources) {
            return this.allocatedResources((Output<Map<String, String>>)Output.of(allocatedResources));
        }

        public Builder allocatedResourcesStatus(@Nullable Output<List<ResourceStatusArgs>> allocatedResourcesStatus) {
            this.$.allocatedResourcesStatus = allocatedResourcesStatus;
            return this;
        }

        public Builder allocatedResourcesStatus(List<ResourceStatusArgs> allocatedResourcesStatus) {
            return this.allocatedResourcesStatus((Output<List<ResourceStatusArgs>>)Output.of(allocatedResourcesStatus));
        }

        public Builder allocatedResourcesStatus(ResourceStatusArgs ... allocatedResourcesStatus) {
            return this.allocatedResourcesStatus(List.of(allocatedResourcesStatus));
        }

        public Builder containerID(@Nullable Output<String> containerID) {
            this.$.containerID = containerID;
            return this;
        }

        public Builder containerID(String containerID) {
            return this.containerID((Output<String>)Output.of((Object)containerID));
        }

        public Builder image(Output<String> image) {
            this.$.image = image;
            return this;
        }

        public Builder image(String image) {
            return this.image((Output<String>)Output.of((Object)image));
        }

        public Builder imageID(Output<String> imageID) {
            this.$.imageID = imageID;
            return this;
        }

        public Builder imageID(String imageID) {
            return this.imageID((Output<String>)Output.of((Object)imageID));
        }

        public Builder lastState(@Nullable Output<ContainerStateArgs> lastState) {
            this.$.lastState = lastState;
            return this;
        }

        public Builder lastState(ContainerStateArgs lastState) {
            return this.lastState((Output<ContainerStateArgs>)Output.of((Object)((Object)lastState)));
        }

        public Builder name(Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder ready(Output<Boolean> ready) {
            this.$.ready = ready;
            return this;
        }

        public Builder ready(Boolean ready) {
            return this.ready((Output<Boolean>)Output.of((Object)ready));
        }

        public Builder resources(@Nullable Output<ResourceRequirementsArgs> resources) {
            this.$.resources = resources;
            return this;
        }

        public Builder resources(ResourceRequirementsArgs resources) {
            return this.resources((Output<ResourceRequirementsArgs>)Output.of((Object)((Object)resources)));
        }

        public Builder restartCount(Output<Integer> restartCount) {
            this.$.restartCount = restartCount;
            return this;
        }

        public Builder restartCount(Integer restartCount) {
            return this.restartCount((Output<Integer>)Output.of((Object)restartCount));
        }

        public Builder started(@Nullable Output<Boolean> started) {
            this.$.started = started;
            return this;
        }

        public Builder started(Boolean started) {
            return this.started((Output<Boolean>)Output.of((Object)started));
        }

        public Builder state(@Nullable Output<ContainerStateArgs> state) {
            this.$.state = state;
            return this;
        }

        public Builder state(ContainerStateArgs state) {
            return this.state((Output<ContainerStateArgs>)Output.of((Object)((Object)state)));
        }

        public Builder user(@Nullable Output<ContainerUserArgs> user) {
            this.$.user = user;
            return this;
        }

        public Builder user(ContainerUserArgs user) {
            return this.user((Output<ContainerUserArgs>)Output.of((Object)((Object)user)));
        }

        public Builder volumeMounts(@Nullable Output<List<VolumeMountStatusArgs>> volumeMounts) {
            this.$.volumeMounts = volumeMounts;
            return this;
        }

        public Builder volumeMounts(List<VolumeMountStatusArgs> volumeMounts) {
            return this.volumeMounts((Output<List<VolumeMountStatusArgs>>)Output.of(volumeMounts));
        }

        public Builder volumeMounts(VolumeMountStatusArgs ... volumeMounts) {
            return this.volumeMounts(List.of(volumeMounts));
        }

        public ContainerStatusArgs build() {
            if (this.$.image == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "image");
            }
            if (this.$.imageID == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "imageID");
            }
            if (this.$.name == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "name");
            }
            if (this.$.ready == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "ready");
            }
            if (this.$.restartCount == null) {
                throw new MissingRequiredPropertyException("ContainerStatusArgs", "restartCount");
            }
            return this.$;
        }
    }
}

