/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.HTTPHeaderArgs;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HTTPGetActionArgs
extends ResourceArgs {
    public static final HTTPGetActionArgs Empty = new HTTPGetActionArgs();
    @Import(name="host")
    @Nullable
    private Output<String> host;
    @Import(name="httpHeaders")
    @Nullable
    private Output<List<HTTPHeaderArgs>> httpHeaders;
    @Import(name="path")
    @Nullable
    private Output<String> path;
    @Import(name="port", required=true)
    private Output<Either<Integer, String>> port;
    @Import(name="scheme")
    @Nullable
    private Output<String> scheme;

    public Optional<Output<String>> host() {
        return Optional.ofNullable(this.host);
    }

    public Optional<Output<List<HTTPHeaderArgs>>> httpHeaders() {
        return Optional.ofNullable(this.httpHeaders);
    }

    public Optional<Output<String>> path() {
        return Optional.ofNullable(this.path);
    }

    public Output<Either<Integer, String>> port() {
        return this.port;
    }

    public Optional<Output<String>> scheme() {
        return Optional.ofNullable(this.scheme);
    }

    private HTTPGetActionArgs() {
    }

    private HTTPGetActionArgs(HTTPGetActionArgs $) {
        this.host = $.host;
        this.httpHeaders = $.httpHeaders;
        this.path = $.path;
        this.port = $.port;
        this.scheme = $.scheme;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HTTPGetActionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HTTPGetActionArgs $;

        public Builder() {
            this.$ = new HTTPGetActionArgs();
        }

        public Builder(HTTPGetActionArgs defaults) {
            this.$ = new HTTPGetActionArgs(Objects.requireNonNull(defaults));
        }

        public Builder host(@Nullable Output<String> host) {
            this.$.host = host;
            return this;
        }

        public Builder host(String host) {
            return this.host((Output<String>)Output.of((Object)host));
        }

        public Builder httpHeaders(@Nullable Output<List<HTTPHeaderArgs>> httpHeaders) {
            this.$.httpHeaders = httpHeaders;
            return this;
        }

        public Builder httpHeaders(List<HTTPHeaderArgs> httpHeaders) {
            return this.httpHeaders((Output<List<HTTPHeaderArgs>>)Output.of(httpHeaders));
        }

        public Builder httpHeaders(HTTPHeaderArgs ... httpHeaders) {
            return this.httpHeaders(List.of(httpHeaders));
        }

        public Builder path(@Nullable Output<String> path) {
            this.$.path = path;
            return this;
        }

        public Builder path(String path) {
            return this.path((Output<String>)Output.of((Object)path));
        }

        public Builder port(Output<Either<Integer, String>> port) {
            this.$.port = port;
            return this;
        }

        public Builder port(Either<Integer, String> port) {
            return this.port((Output<Either<Integer, String>>)Output.of(port));
        }

        public Builder port(Integer port) {
            return this.port((Either<Integer, String>)Either.ofLeft((Object)port));
        }

        public Builder port(String port) {
            return this.port((Either<Integer, String>)Either.ofRight((Object)port));
        }

        public Builder scheme(@Nullable Output<String> scheme) {
            this.$.scheme = scheme;
            return this;
        }

        public Builder scheme(String scheme) {
            return this.scheme((Output<String>)Output.of((Object)scheme));
        }

        public HTTPGetActionArgs build() {
            if (this.$.port == null) {
                throw new MissingRequiredPropertyException("HTTPGetActionArgs", "port");
            }
            return this.$;
        }
    }
}

