/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AzureFilePersistentVolumeSource {
    @Nullable
    private Boolean readOnly;
    private String secretName;
    @Nullable
    private String secretNamespace;
    private String shareName;

    private AzureFilePersistentVolumeSource() {
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public String secretName() {
        return this.secretName;
    }

    public Optional<String> secretNamespace() {
        return Optional.ofNullable(this.secretNamespace);
    }

    public String shareName() {
        return this.shareName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AzureFilePersistentVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean readOnly;
        private String secretName;
        @Nullable
        private String secretNamespace;
        private String shareName;

        public Builder() {
        }

        public Builder(AzureFilePersistentVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.readOnly = defaults.readOnly;
            this.secretName = defaults.secretName;
            this.secretNamespace = defaults.secretNamespace;
            this.shareName = defaults.shareName;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder secretName(String secretName) {
            if (secretName == null) {
                throw new MissingRequiredPropertyException("AzureFilePersistentVolumeSource", "secretName");
            }
            this.secretName = secretName;
            return this;
        }

        @CustomType.Setter
        public Builder secretNamespace(@Nullable String secretNamespace) {
            this.secretNamespace = secretNamespace;
            return this;
        }

        @CustomType.Setter
        public Builder shareName(String shareName) {
            if (shareName == null) {
                throw new MissingRequiredPropertyException("AzureFilePersistentVolumeSource", "shareName");
            }
            this.shareName = shareName;
            return this;
        }

        public AzureFilePersistentVolumeSource build() {
            AzureFilePersistentVolumeSource _resultValue = new AzureFilePersistentVolumeSource();
            _resultValue.readOnly = this.readOnly;
            _resultValue.secretName = this.secretName;
            _resultValue.secretNamespace = this.secretNamespace;
            _resultValue.shareName = this.shareName;
            return _resultValue;
        }
    }
}

