/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AzureFileVolumeSource {
    @Nullable
    private Boolean readOnly;
    private String secretName;
    private String shareName;

    private AzureFileVolumeSource() {
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public String secretName() {
        return this.secretName;
    }

    public String shareName() {
        return this.shareName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AzureFileVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean readOnly;
        private String secretName;
        private String shareName;

        public Builder() {
        }

        public Builder(AzureFileVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.readOnly = defaults.readOnly;
            this.secretName = defaults.secretName;
            this.shareName = defaults.shareName;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder secretName(String secretName) {
            if (secretName == null) {
                throw new MissingRequiredPropertyException("AzureFileVolumeSource", "secretName");
            }
            this.secretName = secretName;
            return this;
        }

        @CustomType.Setter
        public Builder shareName(String shareName) {
            if (shareName == null) {
                throw new MissingRequiredPropertyException("AzureFileVolumeSource", "shareName");
            }
            this.shareName = shareName;
            return this;
        }

        public AzureFileVolumeSource build() {
            AzureFileVolumeSource _resultValue = new AzureFileVolumeSource();
            _resultValue.readOnly = this.readOnly;
            _resultValue.secretName = this.secretName;
            _resultValue.shareName = this.shareName;
            return _resultValue;
        }
    }
}

