/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.SecretReference;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CSIPersistentVolumeSource {
    @Nullable
    private SecretReference controllerExpandSecretRef;
    @Nullable
    private SecretReference controllerPublishSecretRef;
    private String driver;
    @Nullable
    private String fsType;
    @Nullable
    private SecretReference nodeExpandSecretRef;
    @Nullable
    private SecretReference nodePublishSecretRef;
    @Nullable
    private SecretReference nodeStageSecretRef;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private Map<String, String> volumeAttributes;
    private String volumeHandle;

    private CSIPersistentVolumeSource() {
    }

    public Optional<SecretReference> controllerExpandSecretRef() {
        return Optional.ofNullable(this.controllerExpandSecretRef);
    }

    public Optional<SecretReference> controllerPublishSecretRef() {
        return Optional.ofNullable(this.controllerPublishSecretRef);
    }

    public String driver() {
        return this.driver;
    }

    public Optional<String> fsType() {
        return Optional.ofNullable(this.fsType);
    }

    public Optional<SecretReference> nodeExpandSecretRef() {
        return Optional.ofNullable(this.nodeExpandSecretRef);
    }

    public Optional<SecretReference> nodePublishSecretRef() {
        return Optional.ofNullable(this.nodePublishSecretRef);
    }

    public Optional<SecretReference> nodeStageSecretRef() {
        return Optional.ofNullable(this.nodeStageSecretRef);
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public Map<String, String> volumeAttributes() {
        return this.volumeAttributes == null ? Map.of() : this.volumeAttributes;
    }

    public String volumeHandle() {
        return this.volumeHandle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CSIPersistentVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private SecretReference controllerExpandSecretRef;
        @Nullable
        private SecretReference controllerPublishSecretRef;
        private String driver;
        @Nullable
        private String fsType;
        @Nullable
        private SecretReference nodeExpandSecretRef;
        @Nullable
        private SecretReference nodePublishSecretRef;
        @Nullable
        private SecretReference nodeStageSecretRef;
        @Nullable
        private Boolean readOnly;
        @Nullable
        private Map<String, String> volumeAttributes;
        private String volumeHandle;

        public Builder() {
        }

        public Builder(CSIPersistentVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.controllerExpandSecretRef = defaults.controllerExpandSecretRef;
            this.controllerPublishSecretRef = defaults.controllerPublishSecretRef;
            this.driver = defaults.driver;
            this.fsType = defaults.fsType;
            this.nodeExpandSecretRef = defaults.nodeExpandSecretRef;
            this.nodePublishSecretRef = defaults.nodePublishSecretRef;
            this.nodeStageSecretRef = defaults.nodeStageSecretRef;
            this.readOnly = defaults.readOnly;
            this.volumeAttributes = defaults.volumeAttributes;
            this.volumeHandle = defaults.volumeHandle;
        }

        @CustomType.Setter
        public Builder controllerExpandSecretRef(@Nullable SecretReference controllerExpandSecretRef) {
            this.controllerExpandSecretRef = controllerExpandSecretRef;
            return this;
        }

        @CustomType.Setter
        public Builder controllerPublishSecretRef(@Nullable SecretReference controllerPublishSecretRef) {
            this.controllerPublishSecretRef = controllerPublishSecretRef;
            return this;
        }

        @CustomType.Setter
        public Builder driver(String driver) {
            if (driver == null) {
                throw new MissingRequiredPropertyException("CSIPersistentVolumeSource", "driver");
            }
            this.driver = driver;
            return this;
        }

        @CustomType.Setter
        public Builder fsType(@Nullable String fsType) {
            this.fsType = fsType;
            return this;
        }

        @CustomType.Setter
        public Builder nodeExpandSecretRef(@Nullable SecretReference nodeExpandSecretRef) {
            this.nodeExpandSecretRef = nodeExpandSecretRef;
            return this;
        }

        @CustomType.Setter
        public Builder nodePublishSecretRef(@Nullable SecretReference nodePublishSecretRef) {
            this.nodePublishSecretRef = nodePublishSecretRef;
            return this;
        }

        @CustomType.Setter
        public Builder nodeStageSecretRef(@Nullable SecretReference nodeStageSecretRef) {
            this.nodeStageSecretRef = nodeStageSecretRef;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder volumeAttributes(@Nullable Map<String, String> volumeAttributes) {
            this.volumeAttributes = volumeAttributes;
            return this;
        }

        @CustomType.Setter
        public Builder volumeHandle(String volumeHandle) {
            if (volumeHandle == null) {
                throw new MissingRequiredPropertyException("CSIPersistentVolumeSource", "volumeHandle");
            }
            this.volumeHandle = volumeHandle;
            return this;
        }

        public CSIPersistentVolumeSource build() {
            CSIPersistentVolumeSource _resultValue = new CSIPersistentVolumeSource();
            _resultValue.controllerExpandSecretRef = this.controllerExpandSecretRef;
            _resultValue.controllerPublishSecretRef = this.controllerPublishSecretRef;
            _resultValue.driver = this.driver;
            _resultValue.fsType = this.fsType;
            _resultValue.nodeExpandSecretRef = this.nodeExpandSecretRef;
            _resultValue.nodePublishSecretRef = this.nodePublishSecretRef;
            _resultValue.nodeStageSecretRef = this.nodeStageSecretRef;
            _resultValue.readOnly = this.readOnly;
            _resultValue.volumeAttributes = this.volumeAttributes;
            _resultValue.volumeHandle = this.volumeHandle;
            return _resultValue;
        }
    }
}

