/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CinderVolumeSource {
    @Nullable
    private String fsType;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private LocalObjectReference secretRef;
    private String volumeID;

    private CinderVolumeSource() {
    }

    public Optional<String> fsType() {
        return Optional.ofNullable(this.fsType);
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public Optional<LocalObjectReference> secretRef() {
        return Optional.ofNullable(this.secretRef);
    }

    public String volumeID() {
        return this.volumeID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CinderVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String fsType;
        @Nullable
        private Boolean readOnly;
        @Nullable
        private LocalObjectReference secretRef;
        private String volumeID;

        public Builder() {
        }

        public Builder(CinderVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.fsType = defaults.fsType;
            this.readOnly = defaults.readOnly;
            this.secretRef = defaults.secretRef;
            this.volumeID = defaults.volumeID;
        }

        @CustomType.Setter
        public Builder fsType(@Nullable String fsType) {
            this.fsType = fsType;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder secretRef(@Nullable LocalObjectReference secretRef) {
            this.secretRef = secretRef;
            return this;
        }

        @CustomType.Setter
        public Builder volumeID(String volumeID) {
            if (volumeID == null) {
                throw new MissingRequiredPropertyException("CinderVolumeSource", "volumeID");
            }
            this.volumeID = volumeID;
            return this;
        }

        public CinderVolumeSource build() {
            CinderVolumeSource _resultValue = new CinderVolumeSource();
            _resultValue.fsType = this.fsType;
            _resultValue.readOnly = this.readOnly;
            _resultValue.secretRef = this.secretRef;
            _resultValue.volumeID = this.volumeID;
            return _resultValue;
        }
    }
}

