/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ConfigMap {
    @Nullable
    private String apiVersion;
    @Nullable
    private Map<String, String> binaryData;
    @Nullable
    private Map<String, String> data;
    @Nullable
    private Boolean immutable;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;

    private ConfigMap() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Map<String, String> binaryData() {
        return this.binaryData == null ? Map.of() : this.binaryData;
    }

    public Map<String, String> data() {
        return this.data == null ? Map.of() : this.data;
    }

    public Optional<Boolean> immutable() {
        return Optional.ofNullable(this.immutable);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConfigMap defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private Map<String, String> binaryData;
        @Nullable
        private Map<String, String> data;
        @Nullable
        private Boolean immutable;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;

        public Builder() {
        }

        public Builder(ConfigMap defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.binaryData = defaults.binaryData;
            this.data = defaults.data;
            this.immutable = defaults.immutable;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder binaryData(@Nullable Map<String, String> binaryData) {
            this.binaryData = binaryData;
            return this;
        }

        @CustomType.Setter
        public Builder data(@Nullable Map<String, String> data) {
            this.data = data;
            return this;
        }

        @CustomType.Setter
        public Builder immutable(@Nullable Boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        public ConfigMap build() {
            ConfigMap _resultValue = new ConfigMap();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.binaryData = this.binaryData;
            _resultValue.data = this.data;
            _resultValue.immutable = this.immutable;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            return _resultValue;
        }
    }
}

