/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ConfigMapKeySelector {
    private String key;
    @Nullable
    private String name;
    @Nullable
    private Boolean optional;

    private ConfigMapKeySelector() {
    }

    public String key() {
        return this.key;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Boolean> optional() {
        return Optional.ofNullable(this.optional);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConfigMapKeySelector defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String key;
        @Nullable
        private String name;
        @Nullable
        private Boolean optional;

        public Builder() {
        }

        public Builder(ConfigMapKeySelector defaults) {
            Objects.requireNonNull(defaults);
            this.key = defaults.key;
            this.name = defaults.name;
            this.optional = defaults.optional;
        }

        @CustomType.Setter
        public Builder key(String key) {
            if (key == null) {
                throw new MissingRequiredPropertyException("ConfigMapKeySelector", "key");
            }
            this.key = key;
            return this;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder optional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        public ConfigMapKeySelector build() {
            ConfigMapKeySelector _resultValue = new ConfigMapKeySelector();
            _resultValue.key = this.key;
            _resultValue.name = this.name;
            _resultValue.optional = this.optional;
            return _resultValue;
        }
    }
}

