/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ConfigMapNodeConfigSource {
    private String kubeletConfigKey;
    private String name;
    private String namespace;
    @Nullable
    private String resourceVersion;
    @Nullable
    private String uid;

    private ConfigMapNodeConfigSource() {
    }

    public String kubeletConfigKey() {
        return this.kubeletConfigKey;
    }

    public String name() {
        return this.name;
    }

    public String namespace() {
        return this.namespace;
    }

    public Optional<String> resourceVersion() {
        return Optional.ofNullable(this.resourceVersion);
    }

    public Optional<String> uid() {
        return Optional.ofNullable(this.uid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConfigMapNodeConfigSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String kubeletConfigKey;
        private String name;
        private String namespace;
        @Nullable
        private String resourceVersion;
        @Nullable
        private String uid;

        public Builder() {
        }

        public Builder(ConfigMapNodeConfigSource defaults) {
            Objects.requireNonNull(defaults);
            this.kubeletConfigKey = defaults.kubeletConfigKey;
            this.name = defaults.name;
            this.namespace = defaults.namespace;
            this.resourceVersion = defaults.resourceVersion;
            this.uid = defaults.uid;
        }

        @CustomType.Setter
        public Builder kubeletConfigKey(String kubeletConfigKey) {
            if (kubeletConfigKey == null) {
                throw new MissingRequiredPropertyException("ConfigMapNodeConfigSource", "kubeletConfigKey");
            }
            this.kubeletConfigKey = kubeletConfigKey;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("ConfigMapNodeConfigSource", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder namespace(String namespace) {
            if (namespace == null) {
                throw new MissingRequiredPropertyException("ConfigMapNodeConfigSource", "namespace");
            }
            this.namespace = namespace;
            return this;
        }

        @CustomType.Setter
        public Builder resourceVersion(@Nullable String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        @CustomType.Setter
        public Builder uid(@Nullable String uid) {
            this.uid = uid;
            return this;
        }

        public ConfigMapNodeConfigSource build() {
            ConfigMapNodeConfigSource _resultValue = new ConfigMapNodeConfigSource();
            _resultValue.kubeletConfigKey = this.kubeletConfigKey;
            _resultValue.name = this.name;
            _resultValue.namespace = this.namespace;
            _resultValue.resourceVersion = this.resourceVersion;
            _resultValue.uid = this.uid;
            return _resultValue;
        }
    }
}

