/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ContainerImage {
    private List<String> names;
    @Nullable
    private Integer sizeBytes;

    private ContainerImage() {
    }

    public List<String> names() {
        return this.names;
    }

    public Optional<Integer> sizeBytes() {
        return Optional.ofNullable(this.sizeBytes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerImage defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> names;
        @Nullable
        private Integer sizeBytes;

        public Builder() {
        }

        public Builder(ContainerImage defaults) {
            Objects.requireNonNull(defaults);
            this.names = defaults.names;
            this.sizeBytes = defaults.sizeBytes;
        }

        @CustomType.Setter
        public Builder names(List<String> names) {
            if (names == null) {
                throw new MissingRequiredPropertyException("ContainerImage", "names");
            }
            this.names = names;
            return this;
        }

        public Builder names(String ... names) {
            return this.names(List.of(names));
        }

        @CustomType.Setter
        public Builder sizeBytes(@Nullable Integer sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public ContainerImage build() {
            ContainerImage _resultValue = new ContainerImage();
            _resultValue.names = this.names;
            _resultValue.sizeBytes = this.sizeBytes;
            return _resultValue;
        }
    }
}

