/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.ContainerStateRunning;
import com.pulumi.kubernetes.core.v1.outputs.ContainerStateTerminated;
import com.pulumi.kubernetes.core.v1.outputs.ContainerStateWaiting;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ContainerState {
    @Nullable
    private ContainerStateRunning running;
    @Nullable
    private ContainerStateTerminated terminated;
    @Nullable
    private ContainerStateWaiting waiting;

    private ContainerState() {
    }

    public Optional<ContainerStateRunning> running() {
        return Optional.ofNullable(this.running);
    }

    public Optional<ContainerStateTerminated> terminated() {
        return Optional.ofNullable(this.terminated);
    }

    public Optional<ContainerStateWaiting> waiting() {
        return Optional.ofNullable(this.waiting);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerState defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private ContainerStateRunning running;
        @Nullable
        private ContainerStateTerminated terminated;
        @Nullable
        private ContainerStateWaiting waiting;

        public Builder() {
        }

        public Builder(ContainerState defaults) {
            Objects.requireNonNull(defaults);
            this.running = defaults.running;
            this.terminated = defaults.terminated;
            this.waiting = defaults.waiting;
        }

        @CustomType.Setter
        public Builder running(@Nullable ContainerStateRunning running) {
            this.running = running;
            return this;
        }

        @CustomType.Setter
        public Builder terminated(@Nullable ContainerStateTerminated terminated) {
            this.terminated = terminated;
            return this;
        }

        @CustomType.Setter
        public Builder waiting(@Nullable ContainerStateWaiting waiting) {
            this.waiting = waiting;
            return this;
        }

        public ContainerState build() {
            ContainerState _resultValue = new ContainerState();
            _resultValue.running = this.running;
            _resultValue.terminated = this.terminated;
            _resultValue.waiting = this.waiting;
            return _resultValue;
        }
    }
}

