/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.ContainerStateRunningPatch;
import com.pulumi.kubernetes.core.v1.outputs.ContainerStateTerminatedPatch;
import com.pulumi.kubernetes.core.v1.outputs.ContainerStateWaitingPatch;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ContainerStatePatch {
    @Nullable
    private ContainerStateRunningPatch running;
    @Nullable
    private ContainerStateTerminatedPatch terminated;
    @Nullable
    private ContainerStateWaitingPatch waiting;

    private ContainerStatePatch() {
    }

    public Optional<ContainerStateRunningPatch> running() {
        return Optional.ofNullable(this.running);
    }

    public Optional<ContainerStateTerminatedPatch> terminated() {
        return Optional.ofNullable(this.terminated);
    }

    public Optional<ContainerStateWaitingPatch> waiting() {
        return Optional.ofNullable(this.waiting);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerStatePatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private ContainerStateRunningPatch running;
        @Nullable
        private ContainerStateTerminatedPatch terminated;
        @Nullable
        private ContainerStateWaitingPatch waiting;

        public Builder() {
        }

        public Builder(ContainerStatePatch defaults) {
            Objects.requireNonNull(defaults);
            this.running = defaults.running;
            this.terminated = defaults.terminated;
            this.waiting = defaults.waiting;
        }

        @CustomType.Setter
        public Builder running(@Nullable ContainerStateRunningPatch running) {
            this.running = running;
            return this;
        }

        @CustomType.Setter
        public Builder terminated(@Nullable ContainerStateTerminatedPatch terminated) {
            this.terminated = terminated;
            return this;
        }

        @CustomType.Setter
        public Builder waiting(@Nullable ContainerStateWaitingPatch waiting) {
            this.waiting = waiting;
            return this;
        }

        public ContainerStatePatch build() {
            ContainerStatePatch _resultValue = new ContainerStatePatch();
            _resultValue.running = this.running;
            _resultValue.terminated = this.terminated;
            _resultValue.waiting = this.waiting;
            return _resultValue;
        }
    }
}

