/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.ContainerState;
import com.pulumi.kubernetes.core.v1.outputs.ContainerUser;
import com.pulumi.kubernetes.core.v1.outputs.ResourceRequirements;
import com.pulumi.kubernetes.core.v1.outputs.ResourceStatus;
import com.pulumi.kubernetes.core.v1.outputs.VolumeMountStatus;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ContainerStatus {
    @Nullable
    private Map<String, String> allocatedResources;
    @Nullable
    private List<ResourceStatus> allocatedResourcesStatus;
    @Nullable
    private String containerID;
    private String image;
    private String imageID;
    @Nullable
    private ContainerState lastState;
    private String name;
    private Boolean ready;
    @Nullable
    private ResourceRequirements resources;
    private Integer restartCount;
    @Nullable
    private Boolean started;
    @Nullable
    private ContainerState state;
    @Nullable
    private ContainerUser user;
    @Nullable
    private List<VolumeMountStatus> volumeMounts;

    private ContainerStatus() {
    }

    public Map<String, String> allocatedResources() {
        return this.allocatedResources == null ? Map.of() : this.allocatedResources;
    }

    public List<ResourceStatus> allocatedResourcesStatus() {
        return this.allocatedResourcesStatus == null ? List.of() : this.allocatedResourcesStatus;
    }

    public Optional<String> containerID() {
        return Optional.ofNullable(this.containerID);
    }

    public String image() {
        return this.image;
    }

    public String imageID() {
        return this.imageID;
    }

    public Optional<ContainerState> lastState() {
        return Optional.ofNullable(this.lastState);
    }

    public String name() {
        return this.name;
    }

    public Boolean ready() {
        return this.ready;
    }

    public Optional<ResourceRequirements> resources() {
        return Optional.ofNullable(this.resources);
    }

    public Integer restartCount() {
        return this.restartCount;
    }

    public Optional<Boolean> started() {
        return Optional.ofNullable(this.started);
    }

    public Optional<ContainerState> state() {
        return Optional.ofNullable(this.state);
    }

    public Optional<ContainerUser> user() {
        return Optional.ofNullable(this.user);
    }

    public List<VolumeMountStatus> volumeMounts() {
        return this.volumeMounts == null ? List.of() : this.volumeMounts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Map<String, String> allocatedResources;
        @Nullable
        private List<ResourceStatus> allocatedResourcesStatus;
        @Nullable
        private String containerID;
        private String image;
        private String imageID;
        @Nullable
        private ContainerState lastState;
        private String name;
        private Boolean ready;
        @Nullable
        private ResourceRequirements resources;
        private Integer restartCount;
        @Nullable
        private Boolean started;
        @Nullable
        private ContainerState state;
        @Nullable
        private ContainerUser user;
        @Nullable
        private List<VolumeMountStatus> volumeMounts;

        public Builder() {
        }

        public Builder(ContainerStatus defaults) {
            Objects.requireNonNull(defaults);
            this.allocatedResources = defaults.allocatedResources;
            this.allocatedResourcesStatus = defaults.allocatedResourcesStatus;
            this.containerID = defaults.containerID;
            this.image = defaults.image;
            this.imageID = defaults.imageID;
            this.lastState = defaults.lastState;
            this.name = defaults.name;
            this.ready = defaults.ready;
            this.resources = defaults.resources;
            this.restartCount = defaults.restartCount;
            this.started = defaults.started;
            this.state = defaults.state;
            this.user = defaults.user;
            this.volumeMounts = defaults.volumeMounts;
        }

        @CustomType.Setter
        public Builder allocatedResources(@Nullable Map<String, String> allocatedResources) {
            this.allocatedResources = allocatedResources;
            return this;
        }

        @CustomType.Setter
        public Builder allocatedResourcesStatus(@Nullable List<ResourceStatus> allocatedResourcesStatus) {
            this.allocatedResourcesStatus = allocatedResourcesStatus;
            return this;
        }

        public Builder allocatedResourcesStatus(ResourceStatus ... allocatedResourcesStatus) {
            return this.allocatedResourcesStatus(List.of(allocatedResourcesStatus));
        }

        @CustomType.Setter
        public Builder containerID(@Nullable String containerID) {
            this.containerID = containerID;
            return this;
        }

        @CustomType.Setter
        public Builder image(String image) {
            if (image == null) {
                throw new MissingRequiredPropertyException("ContainerStatus", "image");
            }
            this.image = image;
            return this;
        }

        @CustomType.Setter
        public Builder imageID(String imageID) {
            if (imageID == null) {
                throw new MissingRequiredPropertyException("ContainerStatus", "imageID");
            }
            this.imageID = imageID;
            return this;
        }

        @CustomType.Setter
        public Builder lastState(@Nullable ContainerState lastState) {
            this.lastState = lastState;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("ContainerStatus", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder ready(Boolean ready) {
            if (ready == null) {
                throw new MissingRequiredPropertyException("ContainerStatus", "ready");
            }
            this.ready = ready;
            return this;
        }

        @CustomType.Setter
        public Builder resources(@Nullable ResourceRequirements resources) {
            this.resources = resources;
            return this;
        }

        @CustomType.Setter
        public Builder restartCount(Integer restartCount) {
            if (restartCount == null) {
                throw new MissingRequiredPropertyException("ContainerStatus", "restartCount");
            }
            this.restartCount = restartCount;
            return this;
        }

        @CustomType.Setter
        public Builder started(@Nullable Boolean started) {
            this.started = started;
            return this;
        }

        @CustomType.Setter
        public Builder state(@Nullable ContainerState state) {
            this.state = state;
            return this;
        }

        @CustomType.Setter
        public Builder user(@Nullable ContainerUser user) {
            this.user = user;
            return this;
        }

        @CustomType.Setter
        public Builder volumeMounts(@Nullable List<VolumeMountStatus> volumeMounts) {
            this.volumeMounts = volumeMounts;
            return this;
        }

        public Builder volumeMounts(VolumeMountStatus ... volumeMounts) {
            return this.volumeMounts(List.of(volumeMounts));
        }

        public ContainerStatus build() {
            ContainerStatus _resultValue = new ContainerStatus();
            _resultValue.allocatedResources = this.allocatedResources;
            _resultValue.allocatedResourcesStatus = this.allocatedResourcesStatus;
            _resultValue.containerID = this.containerID;
            _resultValue.image = this.image;
            _resultValue.imageID = this.imageID;
            _resultValue.lastState = this.lastState;
            _resultValue.name = this.name;
            _resultValue.ready = this.ready;
            _resultValue.resources = this.resources;
            _resultValue.restartCount = this.restartCount;
            _resultValue.started = this.started;
            _resultValue.state = this.state;
            _resultValue.user = this.user;
            _resultValue.volumeMounts = this.volumeMounts;
            return _resultValue;
        }
    }
}

