/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.ContainerStatePatch;
import com.pulumi.kubernetes.core.v1.outputs.ContainerUserPatch;
import com.pulumi.kubernetes.core.v1.outputs.ResourceRequirementsPatch;
import com.pulumi.kubernetes.core.v1.outputs.ResourceStatusPatch;
import com.pulumi.kubernetes.core.v1.outputs.VolumeMountStatusPatch;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ContainerStatusPatch {
    @Nullable
    private Map<String, String> allocatedResources;
    @Nullable
    private List<ResourceStatusPatch> allocatedResourcesStatus;
    @Nullable
    private String containerID;
    @Nullable
    private String image;
    @Nullable
    private String imageID;
    @Nullable
    private ContainerStatePatch lastState;
    @Nullable
    private String name;
    @Nullable
    private Boolean ready;
    @Nullable
    private ResourceRequirementsPatch resources;
    @Nullable
    private Integer restartCount;
    @Nullable
    private Boolean started;
    @Nullable
    private ContainerStatePatch state;
    @Nullable
    private ContainerUserPatch user;
    @Nullable
    private List<VolumeMountStatusPatch> volumeMounts;

    private ContainerStatusPatch() {
    }

    public Map<String, String> allocatedResources() {
        return this.allocatedResources == null ? Map.of() : this.allocatedResources;
    }

    public List<ResourceStatusPatch> allocatedResourcesStatus() {
        return this.allocatedResourcesStatus == null ? List.of() : this.allocatedResourcesStatus;
    }

    public Optional<String> containerID() {
        return Optional.ofNullable(this.containerID);
    }

    public Optional<String> image() {
        return Optional.ofNullable(this.image);
    }

    public Optional<String> imageID() {
        return Optional.ofNullable(this.imageID);
    }

    public Optional<ContainerStatePatch> lastState() {
        return Optional.ofNullable(this.lastState);
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Boolean> ready() {
        return Optional.ofNullable(this.ready);
    }

    public Optional<ResourceRequirementsPatch> resources() {
        return Optional.ofNullable(this.resources);
    }

    public Optional<Integer> restartCount() {
        return Optional.ofNullable(this.restartCount);
    }

    public Optional<Boolean> started() {
        return Optional.ofNullable(this.started);
    }

    public Optional<ContainerStatePatch> state() {
        return Optional.ofNullable(this.state);
    }

    public Optional<ContainerUserPatch> user() {
        return Optional.ofNullable(this.user);
    }

    public List<VolumeMountStatusPatch> volumeMounts() {
        return this.volumeMounts == null ? List.of() : this.volumeMounts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerStatusPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Map<String, String> allocatedResources;
        @Nullable
        private List<ResourceStatusPatch> allocatedResourcesStatus;
        @Nullable
        private String containerID;
        @Nullable
        private String image;
        @Nullable
        private String imageID;
        @Nullable
        private ContainerStatePatch lastState;
        @Nullable
        private String name;
        @Nullable
        private Boolean ready;
        @Nullable
        private ResourceRequirementsPatch resources;
        @Nullable
        private Integer restartCount;
        @Nullable
        private Boolean started;
        @Nullable
        private ContainerStatePatch state;
        @Nullable
        private ContainerUserPatch user;
        @Nullable
        private List<VolumeMountStatusPatch> volumeMounts;

        public Builder() {
        }

        public Builder(ContainerStatusPatch defaults) {
            Objects.requireNonNull(defaults);
            this.allocatedResources = defaults.allocatedResources;
            this.allocatedResourcesStatus = defaults.allocatedResourcesStatus;
            this.containerID = defaults.containerID;
            this.image = defaults.image;
            this.imageID = defaults.imageID;
            this.lastState = defaults.lastState;
            this.name = defaults.name;
            this.ready = defaults.ready;
            this.resources = defaults.resources;
            this.restartCount = defaults.restartCount;
            this.started = defaults.started;
            this.state = defaults.state;
            this.user = defaults.user;
            this.volumeMounts = defaults.volumeMounts;
        }

        @CustomType.Setter
        public Builder allocatedResources(@Nullable Map<String, String> allocatedResources) {
            this.allocatedResources = allocatedResources;
            return this;
        }

        @CustomType.Setter
        public Builder allocatedResourcesStatus(@Nullable List<ResourceStatusPatch> allocatedResourcesStatus) {
            this.allocatedResourcesStatus = allocatedResourcesStatus;
            return this;
        }

        public Builder allocatedResourcesStatus(ResourceStatusPatch ... allocatedResourcesStatus) {
            return this.allocatedResourcesStatus(List.of(allocatedResourcesStatus));
        }

        @CustomType.Setter
        public Builder containerID(@Nullable String containerID) {
            this.containerID = containerID;
            return this;
        }

        @CustomType.Setter
        public Builder image(@Nullable String image) {
            this.image = image;
            return this;
        }

        @CustomType.Setter
        public Builder imageID(@Nullable String imageID) {
            this.imageID = imageID;
            return this;
        }

        @CustomType.Setter
        public Builder lastState(@Nullable ContainerStatePatch lastState) {
            this.lastState = lastState;
            return this;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder ready(@Nullable Boolean ready) {
            this.ready = ready;
            return this;
        }

        @CustomType.Setter
        public Builder resources(@Nullable ResourceRequirementsPatch resources) {
            this.resources = resources;
            return this;
        }

        @CustomType.Setter
        public Builder restartCount(@Nullable Integer restartCount) {
            this.restartCount = restartCount;
            return this;
        }

        @CustomType.Setter
        public Builder started(@Nullable Boolean started) {
            this.started = started;
            return this;
        }

        @CustomType.Setter
        public Builder state(@Nullable ContainerStatePatch state) {
            this.state = state;
            return this;
        }

        @CustomType.Setter
        public Builder user(@Nullable ContainerUserPatch user) {
            this.user = user;
            return this;
        }

        @CustomType.Setter
        public Builder volumeMounts(@Nullable List<VolumeMountStatusPatch> volumeMounts) {
            this.volumeMounts = volumeMounts;
            return this;
        }

        public Builder volumeMounts(VolumeMountStatusPatch ... volumeMounts) {
            return this.volumeMounts(List.of(volumeMounts));
        }

        public ContainerStatusPatch build() {
            ContainerStatusPatch _resultValue = new ContainerStatusPatch();
            _resultValue.allocatedResources = this.allocatedResources;
            _resultValue.allocatedResourcesStatus = this.allocatedResourcesStatus;
            _resultValue.containerID = this.containerID;
            _resultValue.image = this.image;
            _resultValue.imageID = this.imageID;
            _resultValue.lastState = this.lastState;
            _resultValue.name = this.name;
            _resultValue.ready = this.ready;
            _resultValue.resources = this.resources;
            _resultValue.restartCount = this.restartCount;
            _resultValue.started = this.started;
            _resultValue.state = this.state;
            _resultValue.user = this.user;
            _resultValue.volumeMounts = this.volumeMounts;
            return _resultValue;
        }
    }
}

