/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReference;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EndpointAddress {
    @Nullable
    private String hostname;
    private String ip;
    @Nullable
    private String nodeName;
    @Nullable
    private ObjectReference targetRef;

    private EndpointAddress() {
    }

    public Optional<String> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    public String ip() {
        return this.ip;
    }

    public Optional<String> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    public Optional<ObjectReference> targetRef() {
        return Optional.ofNullable(this.targetRef);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointAddress defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String hostname;
        private String ip;
        @Nullable
        private String nodeName;
        @Nullable
        private ObjectReference targetRef;

        public Builder() {
        }

        public Builder(EndpointAddress defaults) {
            Objects.requireNonNull(defaults);
            this.hostname = defaults.hostname;
            this.ip = defaults.ip;
            this.nodeName = defaults.nodeName;
            this.targetRef = defaults.targetRef;
        }

        @CustomType.Setter
        public Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @CustomType.Setter
        public Builder ip(String ip) {
            if (ip == null) {
                throw new MissingRequiredPropertyException("EndpointAddress", "ip");
            }
            this.ip = ip;
            return this;
        }

        @CustomType.Setter
        public Builder nodeName(@Nullable String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        @CustomType.Setter
        public Builder targetRef(@Nullable ObjectReference targetRef) {
            this.targetRef = targetRef;
            return this;
        }

        public EndpointAddress build() {
            EndpointAddress _resultValue = new EndpointAddress();
            _resultValue.hostname = this.hostname;
            _resultValue.ip = this.ip;
            _resultValue.nodeName = this.nodeName;
            _resultValue.targetRef = this.targetRef;
            return _resultValue;
        }
    }
}

