/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EndpointPort {
    @Nullable
    private String appProtocol;
    @Nullable
    private String name;
    private Integer port;
    @Nullable
    private String protocol;

    private EndpointPort() {
    }

    public Optional<String> appProtocol() {
        return Optional.ofNullable(this.appProtocol);
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Integer port() {
        return this.port;
    }

    public Optional<String> protocol() {
        return Optional.ofNullable(this.protocol);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EndpointPort defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String appProtocol;
        @Nullable
        private String name;
        private Integer port;
        @Nullable
        private String protocol;

        public Builder() {
        }

        public Builder(EndpointPort defaults) {
            Objects.requireNonNull(defaults);
            this.appProtocol = defaults.appProtocol;
            this.name = defaults.name;
            this.port = defaults.port;
            this.protocol = defaults.protocol;
        }

        @CustomType.Setter
        public Builder appProtocol(@Nullable String appProtocol) {
            this.appProtocol = appProtocol;
            return this;
        }

        @CustomType.Setter
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder port(Integer port) {
            if (port == null) {
                throw new MissingRequiredPropertyException("EndpointPort", "port");
            }
            this.port = port;
            return this;
        }

        @CustomType.Setter
        public Builder protocol(@Nullable String protocol) {
            this.protocol = protocol;
            return this;
        }

        public EndpointPort build() {
            EndpointPort _resultValue = new EndpointPort();
            _resultValue.appProtocol = this.appProtocol;
            _resultValue.name = this.name;
            _resultValue.port = this.port;
            _resultValue.protocol = this.protocol;
            return _resultValue;
        }
    }
}

