/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.EndpointSubset;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class Endpoints {
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    @Nullable
    private List<EndpointSubset> subsets;

    private Endpoints() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public List<EndpointSubset> subsets() {
        return this.subsets == null ? List.of() : this.subsets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Endpoints defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        @Nullable
        private List<EndpointSubset> subsets;

        public Builder() {
        }

        public Builder(Endpoints defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.subsets = defaults.subsets;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder subsets(@Nullable List<EndpointSubset> subsets) {
            this.subsets = subsets;
            return this;
        }

        public Builder subsets(EndpointSubset ... subsets) {
            return this.subsets(List.of(subsets));
        }

        public Endpoints build() {
            Endpoints _resultValue = new Endpoints();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.subsets = this.subsets;
            return _resultValue;
        }
    }
}

