/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.EnvVarSource;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EnvVar {
    private String name;
    @Nullable
    private String value;
    @Nullable
    private EnvVarSource valueFrom;

    private EnvVar() {
    }

    public String name() {
        return this.name;
    }

    public Optional<String> value() {
        return Optional.ofNullable(this.value);
    }

    public Optional<EnvVarSource> valueFrom() {
        return Optional.ofNullable(this.valueFrom);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EnvVar defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String name;
        @Nullable
        private String value;
        @Nullable
        private EnvVarSource valueFrom;

        public Builder() {
        }

        public Builder(EnvVar defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.value = defaults.value;
            this.valueFrom = defaults.valueFrom;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("EnvVar", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        @CustomType.Setter
        public Builder valueFrom(@Nullable EnvVarSource valueFrom) {
            this.valueFrom = valueFrom;
            return this;
        }

        public EnvVar build() {
            EnvVar _resultValue = new EnvVar();
            _resultValue.name = this.name;
            _resultValue.value = this.value;
            _resultValue.valueFrom = this.valueFrom;
            return _resultValue;
        }
    }
}

