/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.EventSeries;
import com.pulumi.kubernetes.core.v1.outputs.EventSource;
import com.pulumi.kubernetes.core.v1.outputs.ObjectReference;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class Event {
    @Nullable
    private String action;
    @Nullable
    private String apiVersion;
    @Nullable
    private Integer count;
    @Nullable
    private String eventTime;
    @Nullable
    private String firstTimestamp;
    private ObjectReference involvedObject;
    @Nullable
    private String kind;
    @Nullable
    private String lastTimestamp;
    @Nullable
    private String message;
    private ObjectMeta metadata;
    @Nullable
    private String reason;
    @Nullable
    private ObjectReference related;
    @Nullable
    private String reportingComponent;
    @Nullable
    private String reportingInstance;
    @Nullable
    private EventSeries series;
    @Nullable
    private EventSource source;
    @Nullable
    private String type;

    private Event() {
    }

    public Optional<String> action() {
        return Optional.ofNullable(this.action);
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<Integer> count() {
        return Optional.ofNullable(this.count);
    }

    public Optional<String> eventTime() {
        return Optional.ofNullable(this.eventTime);
    }

    public Optional<String> firstTimestamp() {
        return Optional.ofNullable(this.firstTimestamp);
    }

    public ObjectReference involvedObject() {
        return this.involvedObject;
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<String> lastTimestamp() {
        return Optional.ofNullable(this.lastTimestamp);
    }

    public Optional<String> message() {
        return Optional.ofNullable(this.message);
    }

    public ObjectMeta metadata() {
        return this.metadata;
    }

    public Optional<String> reason() {
        return Optional.ofNullable(this.reason);
    }

    public Optional<ObjectReference> related() {
        return Optional.ofNullable(this.related);
    }

    public Optional<String> reportingComponent() {
        return Optional.ofNullable(this.reportingComponent);
    }

    public Optional<String> reportingInstance() {
        return Optional.ofNullable(this.reportingInstance);
    }

    public Optional<EventSeries> series() {
        return Optional.ofNullable(this.series);
    }

    public Optional<EventSource> source() {
        return Optional.ofNullable(this.source);
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Event defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String action;
        @Nullable
        private String apiVersion;
        @Nullable
        private Integer count;
        @Nullable
        private String eventTime;
        @Nullable
        private String firstTimestamp;
        private ObjectReference involvedObject;
        @Nullable
        private String kind;
        @Nullable
        private String lastTimestamp;
        @Nullable
        private String message;
        private ObjectMeta metadata;
        @Nullable
        private String reason;
        @Nullable
        private ObjectReference related;
        @Nullable
        private String reportingComponent;
        @Nullable
        private String reportingInstance;
        @Nullable
        private EventSeries series;
        @Nullable
        private EventSource source;
        @Nullable
        private String type;

        public Builder() {
        }

        public Builder(Event defaults) {
            Objects.requireNonNull(defaults);
            this.action = defaults.action;
            this.apiVersion = defaults.apiVersion;
            this.count = defaults.count;
            this.eventTime = defaults.eventTime;
            this.firstTimestamp = defaults.firstTimestamp;
            this.involvedObject = defaults.involvedObject;
            this.kind = defaults.kind;
            this.lastTimestamp = defaults.lastTimestamp;
            this.message = defaults.message;
            this.metadata = defaults.metadata;
            this.reason = defaults.reason;
            this.related = defaults.related;
            this.reportingComponent = defaults.reportingComponent;
            this.reportingInstance = defaults.reportingInstance;
            this.series = defaults.series;
            this.source = defaults.source;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder count(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        @CustomType.Setter
        public Builder eventTime(@Nullable String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        @CustomType.Setter
        public Builder firstTimestamp(@Nullable String firstTimestamp) {
            this.firstTimestamp = firstTimestamp;
            return this;
        }

        @CustomType.Setter
        public Builder involvedObject(ObjectReference involvedObject) {
            if (involvedObject == null) {
                throw new MissingRequiredPropertyException("Event", "involvedObject");
            }
            this.involvedObject = involvedObject;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder lastTimestamp(@Nullable String lastTimestamp) {
            this.lastTimestamp = lastTimestamp;
            return this;
        }

        @CustomType.Setter
        public Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(ObjectMeta metadata) {
            if (metadata == null) {
                throw new MissingRequiredPropertyException("Event", "metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CustomType.Setter
        public Builder related(@Nullable ObjectReference related) {
            this.related = related;
            return this;
        }

        @CustomType.Setter
        public Builder reportingComponent(@Nullable String reportingComponent) {
            this.reportingComponent = reportingComponent;
            return this;
        }

        @CustomType.Setter
        public Builder reportingInstance(@Nullable String reportingInstance) {
            this.reportingInstance = reportingInstance;
            return this;
        }

        @CustomType.Setter
        public Builder series(@Nullable EventSeries series) {
            this.series = series;
            return this;
        }

        @CustomType.Setter
        public Builder source(@Nullable EventSource source) {
            this.source = source;
            return this;
        }

        @CustomType.Setter
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public Event build() {
            Event _resultValue = new Event();
            _resultValue.action = this.action;
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.count = this.count;
            _resultValue.eventTime = this.eventTime;
            _resultValue.firstTimestamp = this.firstTimestamp;
            _resultValue.involvedObject = this.involvedObject;
            _resultValue.kind = this.kind;
            _resultValue.lastTimestamp = this.lastTimestamp;
            _resultValue.message = this.message;
            _resultValue.metadata = this.metadata;
            _resultValue.reason = this.reason;
            _resultValue.related = this.related;
            _resultValue.reportingComponent = this.reportingComponent;
            _resultValue.reportingInstance = this.reportingInstance;
            _resultValue.series = this.series;
            _resultValue.source = this.source;
            _resultValue.type = this.type;
            return _resultValue;
        }
    }
}

