/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FlexVolumeSource {
    private String driver;
    @Nullable
    private String fsType;
    @Nullable
    private Map<String, String> options;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private LocalObjectReference secretRef;

    private FlexVolumeSource() {
    }

    public String driver() {
        return this.driver;
    }

    public Optional<String> fsType() {
        return Optional.ofNullable(this.fsType);
    }

    public Map<String, String> options() {
        return this.options == null ? Map.of() : this.options;
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public Optional<LocalObjectReference> secretRef() {
        return Optional.ofNullable(this.secretRef);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FlexVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String driver;
        @Nullable
        private String fsType;
        @Nullable
        private Map<String, String> options;
        @Nullable
        private Boolean readOnly;
        @Nullable
        private LocalObjectReference secretRef;

        public Builder() {
        }

        public Builder(FlexVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.driver = defaults.driver;
            this.fsType = defaults.fsType;
            this.options = defaults.options;
            this.readOnly = defaults.readOnly;
            this.secretRef = defaults.secretRef;
        }

        @CustomType.Setter
        public Builder driver(String driver) {
            if (driver == null) {
                throw new MissingRequiredPropertyException("FlexVolumeSource", "driver");
            }
            this.driver = driver;
            return this;
        }

        @CustomType.Setter
        public Builder fsType(@Nullable String fsType) {
            this.fsType = fsType;
            return this;
        }

        @CustomType.Setter
        public Builder options(@Nullable Map<String, String> options) {
            this.options = options;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder secretRef(@Nullable LocalObjectReference secretRef) {
            this.secretRef = secretRef;
            return this;
        }

        public FlexVolumeSource build() {
            FlexVolumeSource _resultValue = new FlexVolumeSource();
            _resultValue.driver = this.driver;
            _resultValue.fsType = this.fsType;
            _resultValue.options = this.options;
            _resultValue.readOnly = this.readOnly;
            _resultValue.secretRef = this.secretRef;
            return _resultValue;
        }
    }
}

