/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GitRepoVolumeSource {
    @Nullable
    private String directory;
    private String repository;
    @Nullable
    private String revision;

    private GitRepoVolumeSource() {
    }

    public Optional<String> directory() {
        return Optional.ofNullable(this.directory);
    }

    public String repository() {
        return this.repository;
    }

    public Optional<String> revision() {
        return Optional.ofNullable(this.revision);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GitRepoVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String directory;
        private String repository;
        @Nullable
        private String revision;

        public Builder() {
        }

        public Builder(GitRepoVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.directory = defaults.directory;
            this.repository = defaults.repository;
            this.revision = defaults.revision;
        }

        @CustomType.Setter
        public Builder directory(@Nullable String directory) {
            this.directory = directory;
            return this;
        }

        @CustomType.Setter
        public Builder repository(String repository) {
            if (repository == null) {
                throw new MissingRequiredPropertyException("GitRepoVolumeSource", "repository");
            }
            this.repository = repository;
            return this;
        }

        @CustomType.Setter
        public Builder revision(@Nullable String revision) {
            this.revision = revision;
            return this;
        }

        public GitRepoVolumeSource build() {
            GitRepoVolumeSource _resultValue = new GitRepoVolumeSource();
            _resultValue.directory = this.directory;
            _resultValue.repository = this.repository;
            _resultValue.revision = this.revision;
            return _resultValue;
        }
    }
}

