/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GlusterfsVolumeSource {
    private String endpoints;
    private String path;
    @Nullable
    private Boolean readOnly;

    private GlusterfsVolumeSource() {
    }

    public String endpoints() {
        return this.endpoints;
    }

    public String path() {
        return this.path;
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GlusterfsVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String endpoints;
        private String path;
        @Nullable
        private Boolean readOnly;

        public Builder() {
        }

        public Builder(GlusterfsVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.endpoints = defaults.endpoints;
            this.path = defaults.path;
            this.readOnly = defaults.readOnly;
        }

        @CustomType.Setter
        public Builder endpoints(String endpoints) {
            if (endpoints == null) {
                throw new MissingRequiredPropertyException("GlusterfsVolumeSource", "endpoints");
            }
            this.endpoints = endpoints;
            return this;
        }

        @CustomType.Setter
        public Builder path(String path) {
            if (path == null) {
                throw new MissingRequiredPropertyException("GlusterfsVolumeSource", "path");
            }
            this.path = path;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public GlusterfsVolumeSource build() {
            GlusterfsVolumeSource _resultValue = new GlusterfsVolumeSource();
            _resultValue.endpoints = this.endpoints;
            _resultValue.path = this.path;
            _resultValue.readOnly = this.readOnly;
            return _resultValue;
        }
    }
}

