/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.Either;
import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.HTTPHeader;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HTTPGetAction {
    @Nullable
    private String host;
    @Nullable
    private List<HTTPHeader> httpHeaders;
    @Nullable
    private String path;
    private Either<Integer, String> port;
    @Nullable
    private String scheme;

    private HTTPGetAction() {
    }

    public Optional<String> host() {
        return Optional.ofNullable(this.host);
    }

    public List<HTTPHeader> httpHeaders() {
        return this.httpHeaders == null ? List.of() : this.httpHeaders;
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public Either<Integer, String> port() {
        return this.port;
    }

    public Optional<String> scheme() {
        return Optional.ofNullable(this.scheme);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HTTPGetAction defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String host;
        @Nullable
        private List<HTTPHeader> httpHeaders;
        @Nullable
        private String path;
        private Either<Integer, String> port;
        @Nullable
        private String scheme;

        public Builder() {
        }

        public Builder(HTTPGetAction defaults) {
            Objects.requireNonNull(defaults);
            this.host = defaults.host;
            this.httpHeaders = defaults.httpHeaders;
            this.path = defaults.path;
            this.port = defaults.port;
            this.scheme = defaults.scheme;
        }

        @CustomType.Setter
        public Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        @CustomType.Setter
        public Builder httpHeaders(@Nullable List<HTTPHeader> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public Builder httpHeaders(HTTPHeader ... httpHeaders) {
            return this.httpHeaders(List.of(httpHeaders));
        }

        @CustomType.Setter
        public Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @CustomType.Setter
        public Builder port(Either<Integer, String> port) {
            if (port == null) {
                throw new MissingRequiredPropertyException("HTTPGetAction", "port");
            }
            this.port = port;
            return this;
        }

        @CustomType.Setter
        public Builder scheme(@Nullable String scheme) {
            this.scheme = scheme;
            return this;
        }

        public HTTPGetAction build() {
            HTTPGetAction _resultValue = new HTTPGetAction();
            _resultValue.host = this.host;
            _resultValue.httpHeaders = this.httpHeaders;
            _resultValue.path = this.path;
            _resultValue.port = this.port;
            _resultValue.scheme = this.scheme;
            return _resultValue;
        }
    }
}

