/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.Either;
import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.HTTPHeaderPatch;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class HTTPGetActionPatch {
    @Nullable
    private String host;
    @Nullable
    private List<HTTPHeaderPatch> httpHeaders;
    @Nullable
    private String path;
    @Nullable
    private Either<Integer, String> port;
    @Nullable
    private String scheme;

    private HTTPGetActionPatch() {
    }

    public Optional<String> host() {
        return Optional.ofNullable(this.host);
    }

    public List<HTTPHeaderPatch> httpHeaders() {
        return this.httpHeaders == null ? List.of() : this.httpHeaders;
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public Optional<Either<Integer, String>> port() {
        return Optional.ofNullable(this.port);
    }

    public Optional<String> scheme() {
        return Optional.ofNullable(this.scheme);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HTTPGetActionPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String host;
        @Nullable
        private List<HTTPHeaderPatch> httpHeaders;
        @Nullable
        private String path;
        @Nullable
        private Either<Integer, String> port;
        @Nullable
        private String scheme;

        public Builder() {
        }

        public Builder(HTTPGetActionPatch defaults) {
            Objects.requireNonNull(defaults);
            this.host = defaults.host;
            this.httpHeaders = defaults.httpHeaders;
            this.path = defaults.path;
            this.port = defaults.port;
            this.scheme = defaults.scheme;
        }

        @CustomType.Setter
        public Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        @CustomType.Setter
        public Builder httpHeaders(@Nullable List<HTTPHeaderPatch> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public Builder httpHeaders(HTTPHeaderPatch ... httpHeaders) {
            return this.httpHeaders(List.of(httpHeaders));
        }

        @CustomType.Setter
        public Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @CustomType.Setter
        public Builder port(@Nullable Either<Integer, String> port) {
            this.port = port;
            return this;
        }

        @CustomType.Setter
        public Builder scheme(@Nullable String scheme) {
            this.scheme = scheme;
            return this;
        }

        public HTTPGetActionPatch build() {
            HTTPGetActionPatch _resultValue = new HTTPGetActionPatch();
            _resultValue.host = this.host;
            _resultValue.httpHeaders = this.httpHeaders;
            _resultValue.path = this.path;
            _resultValue.port = this.port;
            _resultValue.scheme = this.scheme;
            return _resultValue;
        }
    }
}

