/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ISCSIVolumeSource {
    @Nullable
    private Boolean chapAuthDiscovery;
    @Nullable
    private Boolean chapAuthSession;
    @Nullable
    private String fsType;
    @Nullable
    private String initiatorName;
    private String iqn;
    @Nullable
    private String iscsiInterface;
    private Integer lun;
    @Nullable
    private List<String> portals;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private LocalObjectReference secretRef;
    private String targetPortal;

    private ISCSIVolumeSource() {
    }

    public Optional<Boolean> chapAuthDiscovery() {
        return Optional.ofNullable(this.chapAuthDiscovery);
    }

    public Optional<Boolean> chapAuthSession() {
        return Optional.ofNullable(this.chapAuthSession);
    }

    public Optional<String> fsType() {
        return Optional.ofNullable(this.fsType);
    }

    public Optional<String> initiatorName() {
        return Optional.ofNullable(this.initiatorName);
    }

    public String iqn() {
        return this.iqn;
    }

    public Optional<String> iscsiInterface() {
        return Optional.ofNullable(this.iscsiInterface);
    }

    public Integer lun() {
        return this.lun;
    }

    public List<String> portals() {
        return this.portals == null ? List.of() : this.portals;
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public Optional<LocalObjectReference> secretRef() {
        return Optional.ofNullable(this.secretRef);
    }

    public String targetPortal() {
        return this.targetPortal;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ISCSIVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean chapAuthDiscovery;
        @Nullable
        private Boolean chapAuthSession;
        @Nullable
        private String fsType;
        @Nullable
        private String initiatorName;
        private String iqn;
        @Nullable
        private String iscsiInterface;
        private Integer lun;
        @Nullable
        private List<String> portals;
        @Nullable
        private Boolean readOnly;
        @Nullable
        private LocalObjectReference secretRef;
        private String targetPortal;

        public Builder() {
        }

        public Builder(ISCSIVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.chapAuthDiscovery = defaults.chapAuthDiscovery;
            this.chapAuthSession = defaults.chapAuthSession;
            this.fsType = defaults.fsType;
            this.initiatorName = defaults.initiatorName;
            this.iqn = defaults.iqn;
            this.iscsiInterface = defaults.iscsiInterface;
            this.lun = defaults.lun;
            this.portals = defaults.portals;
            this.readOnly = defaults.readOnly;
            this.secretRef = defaults.secretRef;
            this.targetPortal = defaults.targetPortal;
        }

        @CustomType.Setter
        public Builder chapAuthDiscovery(@Nullable Boolean chapAuthDiscovery) {
            this.chapAuthDiscovery = chapAuthDiscovery;
            return this;
        }

        @CustomType.Setter
        public Builder chapAuthSession(@Nullable Boolean chapAuthSession) {
            this.chapAuthSession = chapAuthSession;
            return this;
        }

        @CustomType.Setter
        public Builder fsType(@Nullable String fsType) {
            this.fsType = fsType;
            return this;
        }

        @CustomType.Setter
        public Builder initiatorName(@Nullable String initiatorName) {
            this.initiatorName = initiatorName;
            return this;
        }

        @CustomType.Setter
        public Builder iqn(String iqn) {
            if (iqn == null) {
                throw new MissingRequiredPropertyException("ISCSIVolumeSource", "iqn");
            }
            this.iqn = iqn;
            return this;
        }

        @CustomType.Setter
        public Builder iscsiInterface(@Nullable String iscsiInterface) {
            this.iscsiInterface = iscsiInterface;
            return this;
        }

        @CustomType.Setter
        public Builder lun(Integer lun) {
            if (lun == null) {
                throw new MissingRequiredPropertyException("ISCSIVolumeSource", "lun");
            }
            this.lun = lun;
            return this;
        }

        @CustomType.Setter
        public Builder portals(@Nullable List<String> portals) {
            this.portals = portals;
            return this;
        }

        public Builder portals(String ... portals) {
            return this.portals(List.of(portals));
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder secretRef(@Nullable LocalObjectReference secretRef) {
            this.secretRef = secretRef;
            return this;
        }

        @CustomType.Setter
        public Builder targetPortal(String targetPortal) {
            if (targetPortal == null) {
                throw new MissingRequiredPropertyException("ISCSIVolumeSource", "targetPortal");
            }
            this.targetPortal = targetPortal;
            return this;
        }

        public ISCSIVolumeSource build() {
            ISCSIVolumeSource _resultValue = new ISCSIVolumeSource();
            _resultValue.chapAuthDiscovery = this.chapAuthDiscovery;
            _resultValue.chapAuthSession = this.chapAuthSession;
            _resultValue.fsType = this.fsType;
            _resultValue.initiatorName = this.initiatorName;
            _resultValue.iqn = this.iqn;
            _resultValue.iscsiInterface = this.iscsiInterface;
            _resultValue.lun = this.lun;
            _resultValue.portals = this.portals;
            _resultValue.readOnly = this.readOnly;
            _resultValue.secretRef = this.secretRef;
            _resultValue.targetPortal = this.targetPortal;
            return _resultValue;
        }
    }
}

