/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.PortStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LoadBalancerIngress {
    @Nullable
    private String hostname;
    @Nullable
    private String ip;
    @Nullable
    private String ipMode;
    @Nullable
    private List<PortStatus> ports;

    private LoadBalancerIngress() {
    }

    public Optional<String> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    public Optional<String> ip() {
        return Optional.ofNullable(this.ip);
    }

    public Optional<String> ipMode() {
        return Optional.ofNullable(this.ipMode);
    }

    public List<PortStatus> ports() {
        return this.ports == null ? List.of() : this.ports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoadBalancerIngress defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String hostname;
        @Nullable
        private String ip;
        @Nullable
        private String ipMode;
        @Nullable
        private List<PortStatus> ports;

        public Builder() {
        }

        public Builder(LoadBalancerIngress defaults) {
            Objects.requireNonNull(defaults);
            this.hostname = defaults.hostname;
            this.ip = defaults.ip;
            this.ipMode = defaults.ipMode;
            this.ports = defaults.ports;
        }

        @CustomType.Setter
        public Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @CustomType.Setter
        public Builder ip(@Nullable String ip) {
            this.ip = ip;
            return this;
        }

        @CustomType.Setter
        public Builder ipMode(@Nullable String ipMode) {
            this.ipMode = ipMode;
            return this;
        }

        @CustomType.Setter
        public Builder ports(@Nullable List<PortStatus> ports) {
            this.ports = ports;
            return this;
        }

        public Builder ports(PortStatus ... ports) {
            return this.ports(List.of(ports));
        }

        public LoadBalancerIngress build() {
            LoadBalancerIngress _resultValue = new LoadBalancerIngress();
            _resultValue.hostname = this.hostname;
            _resultValue.ip = this.ip;
            _resultValue.ipMode = this.ipMode;
            _resultValue.ports = this.ports;
            return _resultValue;
        }
    }
}

