/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class NFSVolumeSource {
    private String path;
    @Nullable
    private Boolean readOnly;
    private String server;

    private NFSVolumeSource() {
    }

    public String path() {
        return this.path;
    }

    public Optional<Boolean> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public String server() {
        return this.server;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NFSVolumeSource defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String path;
        @Nullable
        private Boolean readOnly;
        private String server;

        public Builder() {
        }

        public Builder(NFSVolumeSource defaults) {
            Objects.requireNonNull(defaults);
            this.path = defaults.path;
            this.readOnly = defaults.readOnly;
            this.server = defaults.server;
        }

        @CustomType.Setter
        public Builder path(String path) {
            if (path == null) {
                throw new MissingRequiredPropertyException("NFSVolumeSource", "path");
            }
            this.path = path;
            return this;
        }

        @CustomType.Setter
        public Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @CustomType.Setter
        public Builder server(String server) {
            if (server == null) {
                throw new MissingRequiredPropertyException("NFSVolumeSource", "server");
            }
            this.server = server;
            return this;
        }

        public NFSVolumeSource build() {
            NFSVolumeSource _resultValue = new NFSVolumeSource();
            _resultValue.path = this.path;
            _resultValue.readOnly = this.readOnly;
            _resultValue.server = this.server;
            return _resultValue;
        }
    }
}

