/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.NodeConfigSource;
import com.pulumi.kubernetes.core.v1.outputs.Taint;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class NodeSpec {
    @Nullable
    private NodeConfigSource configSource;
    @Nullable
    private String externalID;
    @Nullable
    private String podCIDR;
    @Nullable
    private List<String> podCIDRs;
    @Nullable
    private String providerID;
    @Nullable
    private List<Taint> taints;
    @Nullable
    private Boolean unschedulable;

    private NodeSpec() {
    }

    public Optional<NodeConfigSource> configSource() {
        return Optional.ofNullable(this.configSource);
    }

    public Optional<String> externalID() {
        return Optional.ofNullable(this.externalID);
    }

    public Optional<String> podCIDR() {
        return Optional.ofNullable(this.podCIDR);
    }

    public List<String> podCIDRs() {
        return this.podCIDRs == null ? List.of() : this.podCIDRs;
    }

    public Optional<String> providerID() {
        return Optional.ofNullable(this.providerID);
    }

    public List<Taint> taints() {
        return this.taints == null ? List.of() : this.taints;
    }

    public Optional<Boolean> unschedulable() {
        return Optional.ofNullable(this.unschedulable);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NodeSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private NodeConfigSource configSource;
        @Nullable
        private String externalID;
        @Nullable
        private String podCIDR;
        @Nullable
        private List<String> podCIDRs;
        @Nullable
        private String providerID;
        @Nullable
        private List<Taint> taints;
        @Nullable
        private Boolean unschedulable;

        public Builder() {
        }

        public Builder(NodeSpec defaults) {
            Objects.requireNonNull(defaults);
            this.configSource = defaults.configSource;
            this.externalID = defaults.externalID;
            this.podCIDR = defaults.podCIDR;
            this.podCIDRs = defaults.podCIDRs;
            this.providerID = defaults.providerID;
            this.taints = defaults.taints;
            this.unschedulable = defaults.unschedulable;
        }

        @CustomType.Setter
        public Builder configSource(@Nullable NodeConfigSource configSource) {
            this.configSource = configSource;
            return this;
        }

        @CustomType.Setter
        public Builder externalID(@Nullable String externalID) {
            this.externalID = externalID;
            return this;
        }

        @CustomType.Setter
        public Builder podCIDR(@Nullable String podCIDR) {
            this.podCIDR = podCIDR;
            return this;
        }

        @CustomType.Setter
        public Builder podCIDRs(@Nullable List<String> podCIDRs) {
            this.podCIDRs = podCIDRs;
            return this;
        }

        public Builder podCIDRs(String ... podCIDRs) {
            return this.podCIDRs(List.of(podCIDRs));
        }

        @CustomType.Setter
        public Builder providerID(@Nullable String providerID) {
            this.providerID = providerID;
            return this;
        }

        @CustomType.Setter
        public Builder taints(@Nullable List<Taint> taints) {
            this.taints = taints;
            return this;
        }

        public Builder taints(Taint ... taints) {
            return this.taints(List.of(taints));
        }

        @CustomType.Setter
        public Builder unschedulable(@Nullable Boolean unschedulable) {
            this.unschedulable = unschedulable;
            return this;
        }

        public NodeSpec build() {
            NodeSpec _resultValue = new NodeSpec();
            _resultValue.configSource = this.configSource;
            _resultValue.externalID = this.externalID;
            _resultValue.podCIDR = this.podCIDR;
            _resultValue.podCIDRs = this.podCIDRs;
            _resultValue.providerID = this.providerID;
            _resultValue.taints = this.taints;
            _resultValue.unschedulable = this.unschedulable;
            return _resultValue;
        }
    }
}

