/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.AttachedVolumePatch;
import com.pulumi.kubernetes.core.v1.outputs.ContainerImagePatch;
import com.pulumi.kubernetes.core.v1.outputs.NodeAddressPatch;
import com.pulumi.kubernetes.core.v1.outputs.NodeConditionPatch;
import com.pulumi.kubernetes.core.v1.outputs.NodeConfigStatusPatch;
import com.pulumi.kubernetes.core.v1.outputs.NodeDaemonEndpointsPatch;
import com.pulumi.kubernetes.core.v1.outputs.NodeFeaturesPatch;
import com.pulumi.kubernetes.core.v1.outputs.NodeRuntimeHandlerPatch;
import com.pulumi.kubernetes.core.v1.outputs.NodeSystemInfoPatch;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class NodeStatusPatch {
    @Nullable
    private List<NodeAddressPatch> addresses;
    @Nullable
    private Map<String, String> allocatable;
    @Nullable
    private Map<String, String> capacity;
    @Nullable
    private List<NodeConditionPatch> conditions;
    @Nullable
    private NodeConfigStatusPatch config;
    @Nullable
    private NodeDaemonEndpointsPatch daemonEndpoints;
    @Nullable
    private NodeFeaturesPatch features;
    @Nullable
    private List<ContainerImagePatch> images;
    @Nullable
    private NodeSystemInfoPatch nodeInfo;
    @Nullable
    private String phase;
    @Nullable
    private List<NodeRuntimeHandlerPatch> runtimeHandlers;
    @Nullable
    private List<AttachedVolumePatch> volumesAttached;
    @Nullable
    private List<String> volumesInUse;

    private NodeStatusPatch() {
    }

    public List<NodeAddressPatch> addresses() {
        return this.addresses == null ? List.of() : this.addresses;
    }

    public Map<String, String> allocatable() {
        return this.allocatable == null ? Map.of() : this.allocatable;
    }

    public Map<String, String> capacity() {
        return this.capacity == null ? Map.of() : this.capacity;
    }

    public List<NodeConditionPatch> conditions() {
        return this.conditions == null ? List.of() : this.conditions;
    }

    public Optional<NodeConfigStatusPatch> config() {
        return Optional.ofNullable(this.config);
    }

    public Optional<NodeDaemonEndpointsPatch> daemonEndpoints() {
        return Optional.ofNullable(this.daemonEndpoints);
    }

    public Optional<NodeFeaturesPatch> features() {
        return Optional.ofNullable(this.features);
    }

    public List<ContainerImagePatch> images() {
        return this.images == null ? List.of() : this.images;
    }

    public Optional<NodeSystemInfoPatch> nodeInfo() {
        return Optional.ofNullable(this.nodeInfo);
    }

    public Optional<String> phase() {
        return Optional.ofNullable(this.phase);
    }

    public List<NodeRuntimeHandlerPatch> runtimeHandlers() {
        return this.runtimeHandlers == null ? List.of() : this.runtimeHandlers;
    }

    public List<AttachedVolumePatch> volumesAttached() {
        return this.volumesAttached == null ? List.of() : this.volumesAttached;
    }

    public List<String> volumesInUse() {
        return this.volumesInUse == null ? List.of() : this.volumesInUse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NodeStatusPatch defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<NodeAddressPatch> addresses;
        @Nullable
        private Map<String, String> allocatable;
        @Nullable
        private Map<String, String> capacity;
        @Nullable
        private List<NodeConditionPatch> conditions;
        @Nullable
        private NodeConfigStatusPatch config;
        @Nullable
        private NodeDaemonEndpointsPatch daemonEndpoints;
        @Nullable
        private NodeFeaturesPatch features;
        @Nullable
        private List<ContainerImagePatch> images;
        @Nullable
        private NodeSystemInfoPatch nodeInfo;
        @Nullable
        private String phase;
        @Nullable
        private List<NodeRuntimeHandlerPatch> runtimeHandlers;
        @Nullable
        private List<AttachedVolumePatch> volumesAttached;
        @Nullable
        private List<String> volumesInUse;

        public Builder() {
        }

        public Builder(NodeStatusPatch defaults) {
            Objects.requireNonNull(defaults);
            this.addresses = defaults.addresses;
            this.allocatable = defaults.allocatable;
            this.capacity = defaults.capacity;
            this.conditions = defaults.conditions;
            this.config = defaults.config;
            this.daemonEndpoints = defaults.daemonEndpoints;
            this.features = defaults.features;
            this.images = defaults.images;
            this.nodeInfo = defaults.nodeInfo;
            this.phase = defaults.phase;
            this.runtimeHandlers = defaults.runtimeHandlers;
            this.volumesAttached = defaults.volumesAttached;
            this.volumesInUse = defaults.volumesInUse;
        }

        @CustomType.Setter
        public Builder addresses(@Nullable List<NodeAddressPatch> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(NodeAddressPatch ... addresses) {
            return this.addresses(List.of(addresses));
        }

        @CustomType.Setter
        public Builder allocatable(@Nullable Map<String, String> allocatable) {
            this.allocatable = allocatable;
            return this;
        }

        @CustomType.Setter
        public Builder capacity(@Nullable Map<String, String> capacity) {
            this.capacity = capacity;
            return this;
        }

        @CustomType.Setter
        public Builder conditions(@Nullable List<NodeConditionPatch> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(NodeConditionPatch ... conditions) {
            return this.conditions(List.of(conditions));
        }

        @CustomType.Setter
        public Builder config(@Nullable NodeConfigStatusPatch config) {
            this.config = config;
            return this;
        }

        @CustomType.Setter
        public Builder daemonEndpoints(@Nullable NodeDaemonEndpointsPatch daemonEndpoints) {
            this.daemonEndpoints = daemonEndpoints;
            return this;
        }

        @CustomType.Setter
        public Builder features(@Nullable NodeFeaturesPatch features) {
            this.features = features;
            return this;
        }

        @CustomType.Setter
        public Builder images(@Nullable List<ContainerImagePatch> images) {
            this.images = images;
            return this;
        }

        public Builder images(ContainerImagePatch ... images) {
            return this.images(List.of(images));
        }

        @CustomType.Setter
        public Builder nodeInfo(@Nullable NodeSystemInfoPatch nodeInfo) {
            this.nodeInfo = nodeInfo;
            return this;
        }

        @CustomType.Setter
        public Builder phase(@Nullable String phase) {
            this.phase = phase;
            return this;
        }

        @CustomType.Setter
        public Builder runtimeHandlers(@Nullable List<NodeRuntimeHandlerPatch> runtimeHandlers) {
            this.runtimeHandlers = runtimeHandlers;
            return this;
        }

        public Builder runtimeHandlers(NodeRuntimeHandlerPatch ... runtimeHandlers) {
            return this.runtimeHandlers(List.of(runtimeHandlers));
        }

        @CustomType.Setter
        public Builder volumesAttached(@Nullable List<AttachedVolumePatch> volumesAttached) {
            this.volumesAttached = volumesAttached;
            return this;
        }

        public Builder volumesAttached(AttachedVolumePatch ... volumesAttached) {
            return this.volumesAttached(List.of(volumesAttached));
        }

        @CustomType.Setter
        public Builder volumesInUse(@Nullable List<String> volumesInUse) {
            this.volumesInUse = volumesInUse;
            return this;
        }

        public Builder volumesInUse(String ... volumesInUse) {
            return this.volumesInUse(List.of(volumesInUse));
        }

        public NodeStatusPatch build() {
            NodeStatusPatch _resultValue = new NodeStatusPatch();
            _resultValue.addresses = this.addresses;
            _resultValue.allocatable = this.allocatable;
            _resultValue.capacity = this.capacity;
            _resultValue.conditions = this.conditions;
            _resultValue.config = this.config;
            _resultValue.daemonEndpoints = this.daemonEndpoints;
            _resultValue.features = this.features;
            _resultValue.images = this.images;
            _resultValue.nodeInfo = this.nodeInfo;
            _resultValue.phase = this.phase;
            _resultValue.runtimeHandlers = this.runtimeHandlers;
            _resultValue.volumesAttached = this.volumesAttached;
            _resultValue.volumesInUse = this.volumesInUse;
            return _resultValue;
        }
    }
}

