/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;

@CustomType
public final class NodeSystemInfo {
    private String architecture;
    private String bootID;
    private String containerRuntimeVersion;
    private String kernelVersion;
    private String kubeProxyVersion;
    private String kubeletVersion;
    private String machineID;
    private String operatingSystem;
    private String osImage;
    private String systemUUID;

    private NodeSystemInfo() {
    }

    public String architecture() {
        return this.architecture;
    }

    public String bootID() {
        return this.bootID;
    }

    public String containerRuntimeVersion() {
        return this.containerRuntimeVersion;
    }

    public String kernelVersion() {
        return this.kernelVersion;
    }

    public String kubeProxyVersion() {
        return this.kubeProxyVersion;
    }

    public String kubeletVersion() {
        return this.kubeletVersion;
    }

    public String machineID() {
        return this.machineID;
    }

    public String operatingSystem() {
        return this.operatingSystem;
    }

    public String osImage() {
        return this.osImage;
    }

    public String systemUUID() {
        return this.systemUUID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NodeSystemInfo defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String architecture;
        private String bootID;
        private String containerRuntimeVersion;
        private String kernelVersion;
        private String kubeProxyVersion;
        private String kubeletVersion;
        private String machineID;
        private String operatingSystem;
        private String osImage;
        private String systemUUID;

        public Builder() {
        }

        public Builder(NodeSystemInfo defaults) {
            Objects.requireNonNull(defaults);
            this.architecture = defaults.architecture;
            this.bootID = defaults.bootID;
            this.containerRuntimeVersion = defaults.containerRuntimeVersion;
            this.kernelVersion = defaults.kernelVersion;
            this.kubeProxyVersion = defaults.kubeProxyVersion;
            this.kubeletVersion = defaults.kubeletVersion;
            this.machineID = defaults.machineID;
            this.operatingSystem = defaults.operatingSystem;
            this.osImage = defaults.osImage;
            this.systemUUID = defaults.systemUUID;
        }

        @CustomType.Setter
        public Builder architecture(String architecture) {
            if (architecture == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "architecture");
            }
            this.architecture = architecture;
            return this;
        }

        @CustomType.Setter
        public Builder bootID(String bootID) {
            if (bootID == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "bootID");
            }
            this.bootID = bootID;
            return this;
        }

        @CustomType.Setter
        public Builder containerRuntimeVersion(String containerRuntimeVersion) {
            if (containerRuntimeVersion == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "containerRuntimeVersion");
            }
            this.containerRuntimeVersion = containerRuntimeVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kernelVersion(String kernelVersion) {
            if (kernelVersion == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "kernelVersion");
            }
            this.kernelVersion = kernelVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kubeProxyVersion(String kubeProxyVersion) {
            if (kubeProxyVersion == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "kubeProxyVersion");
            }
            this.kubeProxyVersion = kubeProxyVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kubeletVersion(String kubeletVersion) {
            if (kubeletVersion == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "kubeletVersion");
            }
            this.kubeletVersion = kubeletVersion;
            return this;
        }

        @CustomType.Setter
        public Builder machineID(String machineID) {
            if (machineID == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "machineID");
            }
            this.machineID = machineID;
            return this;
        }

        @CustomType.Setter
        public Builder operatingSystem(String operatingSystem) {
            if (operatingSystem == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "operatingSystem");
            }
            this.operatingSystem = operatingSystem;
            return this;
        }

        @CustomType.Setter
        public Builder osImage(String osImage) {
            if (osImage == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "osImage");
            }
            this.osImage = osImage;
            return this;
        }

        @CustomType.Setter
        public Builder systemUUID(String systemUUID) {
            if (systemUUID == null) {
                throw new MissingRequiredPropertyException("NodeSystemInfo", "systemUUID");
            }
            this.systemUUID = systemUUID;
            return this;
        }

        public NodeSystemInfo build() {
            NodeSystemInfo _resultValue = new NodeSystemInfo();
            _resultValue.architecture = this.architecture;
            _resultValue.bootID = this.bootID;
            _resultValue.containerRuntimeVersion = this.containerRuntimeVersion;
            _resultValue.kernelVersion = this.kernelVersion;
            _resultValue.kubeProxyVersion = this.kubeProxyVersion;
            _resultValue.kubeletVersion = this.kubeletVersion;
            _resultValue.machineID = this.machineID;
            _resultValue.operatingSystem = this.operatingSystem;
            _resultValue.osImage = this.osImage;
            _resultValue.systemUUID = this.systemUUID;
            return _resultValue;
        }
    }
}

